/*
 * Decompiled with CFR 0.152.
 */
package stream.scotty.demo.flink;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import stream.scotty.core.windowFunction.AggregateFunction;
import stream.scotty.core.windowType.TumblingWindow;
import stream.scotty.core.windowType.Window;
import stream.scotty.core.windowType.WindowMeasure;
import stream.scotty.demo.flink.DemoSource;
import stream.scotty.demo.flink.windowFunctions.QuantileWindowFunction;
import stream.scotty.flinkconnector.KeyedScottyWindowOperator;

public class FlinkQuantileDemo
implements Serializable {
    public static void main(String[] args) throws Exception {
        LocalStreamEnvironment sev = StreamExecutionEnvironment.createLocalEnvironment();
        sev.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        DataStreamSource stream = sev.addSource((SourceFunction)new DemoSource());
        KeyedScottyWindowOperator windowOperator = new KeyedScottyWindowOperator((AggregateFunction)new QuantileWindowFunction(0.5));
        windowOperator.addWindow((Window)new TumblingWindow(WindowMeasure.Time, 1000L));
        stream.keyBy(new int[]{0}).process((KeyedProcessFunction)windowOperator).map((MapFunction & Serializable)x -> (Integer)((Tuple2)x.getAggValues().get((int)0)).f1).print();
        sev.execute("demo");
    }
}

