/*
 * Decompiled with CFR 0.152.
 */
package stream.scotty.demo.flink;

import java.io.Serializable;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.LocalStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import stream.scotty.core.windowFunction.AggregateFunction;
import stream.scotty.core.windowType.SlidingWindow;
import stream.scotty.core.windowType.TumblingWindow;
import stream.scotty.core.windowType.Window;
import stream.scotty.core.windowType.WindowMeasure;
import stream.scotty.demo.flink.DemoSource;
import stream.scotty.demo.flink.windowFunctions.SumWindowFunction;
import stream.scotty.flinkconnector.KeyedScottyWindowOperator;

public class FlinkSumDemo
implements Serializable {
    public static void main(String[] args) throws Exception {
        LocalStreamEnvironment sev = StreamExecutionEnvironment.createLocalEnvironment();
        sev.setStreamTimeCharacteristic(TimeCharacteristic.EventTime);
        sev.setParallelism(1);
        sev.setMaxParallelism(1);
        DataStreamSource stream = sev.addSource((SourceFunction)new DemoSource());
        KeyedScottyWindowOperator processingFunction = new KeyedScottyWindowOperator((AggregateFunction)new SumWindowFunction());
        processingFunction.addWindow((Window)new TumblingWindow(WindowMeasure.Time, 2000L)).addWindow((Window)new SlidingWindow(WindowMeasure.Time, 5000L, 1000L));
        stream.keyBy(new int[]{0}).process((KeyedProcessFunction)processingFunction).print();
        sev.execute("demo");
    }
}

