/*
 * Decompiled with CFR 0.152.
 */
package stream.scotty.demo.flink.windowFunctions;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class QuantileTreeMap
implements Serializable {
    private TreeMap<Integer, Integer> values = new TreeMap();
    private int quantile;
    private int lowercount = 0;
    private int uppercount = 0;
    private double pct;
    public static int counter;

    public QuantileTreeMap(Integer initialValue, double pct) {
        this.values.put(initialValue, 1);
        this.quantile = initialValue;
        this.pct = pct;
    }

    private QuantileTreeMap(int quantile, int lowercount, int uppercount, double pct, TreeMap<Integer, Integer> values) {
        this.quantile = quantile;
        this.lowercount = lowercount;
        this.uppercount = uppercount;
        this.pct = pct;
        this.values = values;
    }

    public QuantileTreeMap addValue(Integer value) {
        this.values.compute(value, (k, v) -> {
            int n;
            if (v == null) {
                n = 1;
            } else {
                v = v + 1;
                n = v;
            }
            return n;
        });
        if (value < this.quantile) {
            ++this.lowercount;
        } else if (value > this.quantile) {
            ++this.uppercount;
        }
        this.updateQuantile();
        return this;
    }

    public void addValues(TreeMap<Integer, Integer> newValues) {
        TreeMap<Integer, Integer> outer = newValues;
        TreeMap<Integer, Integer> innter = this.values;
        counter = innter.size() - outer.size();
        for (Map.Entry<Integer, Integer> entry : outer.entrySet()) {
            if (innter.containsKey(entry.getKey())) {
                innter.put(entry.getKey(), innter.get(entry.getKey()) + entry.getValue());
            } else {
                innter.put(entry.getKey(), entry.getValue());
            }
            if (entry.getKey() < this.quantile) {
                ++this.lowercount;
                continue;
            }
            if (entry.getKey() <= this.quantile) continue;
            ++this.uppercount;
        }
        this.values = innter;
        this.updateQuantile();
    }

    public QuantileTreeMap merge(QuantileTreeMap q) {
        this.addValues(q.getValues());
        return this;
    }

    public TreeMap<Integer, Integer> getValues() {
        return this.values;
    }

    public int getQuantile() {
        return this.quantile;
    }

    private void updateQuantile() {
        Map.Entry<Integer, Integer> tmp;
        int totalCount = this.lowercount + this.values.get(this.quantile) + this.uppercount;
        int currentCount = this.values.get(this.quantile);
        double border = (double)totalCount * this.pct;
        while ((double)this.uppercount > (double)totalCount - Math.ceil(border)) {
            tmp = this.values.higherEntry(this.quantile);
            this.lowercount += currentCount;
            this.uppercount -= tmp.getValue().intValue();
            currentCount = tmp.getValue();
            this.quantile = tmp.getKey();
        }
        while (this.lowercount > (int)border) {
            tmp = this.values.lowerEntry(this.quantile);
            this.uppercount += currentCount;
            this.lowercount -= tmp.getValue().intValue();
            currentCount = tmp.getValue();
            this.quantile = tmp.getKey();
        }
    }

    public QuantileTreeMap clone() {
        return new QuantileTreeMap(this.quantile, this.lowercount, this.uppercount, this.pct, (TreeMap)this.values.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuantileTreeMap quantile1 = (QuantileTreeMap)o;
        if (this.quantile != quantile1.quantile) {
            return false;
        }
        if (this.lowercount != quantile1.lowercount) {
            return false;
        }
        if (this.uppercount != quantile1.uppercount) {
            return false;
        }
        if (Double.compare(quantile1.pct, this.pct) != 0) {
            return false;
        }
        return this.values != null ? this.values.equals(quantile1.values) : quantile1.values == null;
    }

    public int hashCode() {
        int result = this.values != null ? this.values.hashCode() : 0;
        result = 31 * result + this.quantile;
        result = 31 * result + this.lowercount;
        result = 31 * result + this.uppercount;
        long temp = Double.doubleToLongBits(this.pct);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

