/*
 * Decompiled with CFR 0.152.
 */
package stream.scotty.demo.flink.windowFunctions;

import org.apache.flink.api.java.tuple.Tuple2;
import stream.scotty.core.windowFunction.AggregateFunction;
import stream.scotty.core.windowFunction.CloneablePartialStateFunction;
import stream.scotty.demo.flink.windowFunctions.QuantileTreeMap;

public class QuantileWindowFunction
implements AggregateFunction<Tuple2<Integer, Integer>, Tuple2<Integer, QuantileTreeMap>, Tuple2<Integer, Integer>>,
CloneablePartialStateFunction<Tuple2<Integer, QuantileTreeMap>> {
    private final double quantile;

    public QuantileWindowFunction(double quantile) {
        this.quantile = quantile;
    }

    public Tuple2<Integer, QuantileTreeMap> lift(Tuple2<Integer, Integer> inputTuple) {
        return new Tuple2(inputTuple.f0, (Object)new QuantileTreeMap((Integer)inputTuple.f1, this.quantile));
    }

    public Tuple2<Integer, Integer> lower(Tuple2<Integer, QuantileTreeMap> aggregate) {
        return new Tuple2(aggregate.f0, (Object)((QuantileTreeMap)aggregate.f1).getQuantile());
    }

    public Tuple2<Integer, QuantileTreeMap> combine(Tuple2<Integer, QuantileTreeMap> partialAggregate1, Tuple2<Integer, QuantileTreeMap> partialAggregate2) {
        return new Tuple2(partialAggregate1.f0, (Object)((QuantileTreeMap)partialAggregate1.f1).merge((QuantileTreeMap)partialAggregate2.f1));
    }

    public Tuple2<Integer, QuantileTreeMap> liftAndCombine(Tuple2<Integer, QuantileTreeMap> partialAggregate, Tuple2<Integer, Integer> inputTuple) {
        ((QuantileTreeMap)partialAggregate.f1).addValue((Integer)inputTuple.f1);
        return partialAggregate;
    }

    public Tuple2<Integer, QuantileTreeMap> clone(Tuple2<Integer, QuantileTreeMap> partialAggregate) {
        return new Tuple2(partialAggregate.f0, (Object)((QuantileTreeMap)partialAggregate.f1).clone());
    }
}

