/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.ArgumentTypeResolver;
import studio.mevera.imperat.BrigadierManager;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.FlagParameter;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.suggestions.CompletionArg;
import studio.mevera.imperat.command.tree.ArgumentNode;
import studio.mevera.imperat.command.tree.CommandNode;
import studio.mevera.imperat.command.tree.CommandTree;
import studio.mevera.imperat.command.tree.ParameterNode;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.resolvers.PermissionChecker;
import studio.mevera.imperat.util.TypeUtility;

public abstract class BaseBrigadierManager<S extends Source>
implements BrigadierManager<S> {
    protected final Imperat<S> dispatcher;
    protected final List<ArgumentTypeResolver> resolvers = new ArrayList<ArgumentTypeResolver>();

    protected BaseBrigadierManager(Imperat<S> dispatcher) {
        this.dispatcher = dispatcher;
    }

    @Override
    @NotNull
    public <T> LiteralCommandNode<T> parseCommandIntoNode(@NotNull Command<S> command) {
        CommandTree tree = command.tree();
        CommandNode root = tree.uniqueVersionedTree();
        return this.convertRoot(root).build();
    }

    private <T> LiteralArgumentBuilder<T> convertRoot(CommandNode<S> root) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)((Command)root.getData()).name()).requires(obj -> {
            Object source = this.wrapCommandSource(obj);
            return ((Command)root.getData()).isIgnoringACPerms() || this.dispatcher.config().getPermissionChecker().hasPermission(source, root.getPermission());
        });
        this.executor((ArgumentBuilder<?, ?>)builder);
        for (ParameterNode child : root.getChildren()) {
            builder.then(this.convertNode(root, (ParameterNode<?, ?>)root, (ParameterNode<S, ?>)child));
        }
        return builder;
    }

    private <T> com.mojang.brigadier.tree.CommandNode<T> convertNode(CommandNode<S> root, ParameterNode<?, ?> parent, ParameterNode<S, ?> node) {
        ArgumentType<?> argType = this.getArgumentType(node.getData());
        LiteralArgumentBuilder childBuilder = node instanceof CommandNode ? LiteralArgumentBuilder.literal((String)node.getData().name()) : RequiredArgumentBuilder.argument((String)node.getData().name(), argType);
        childBuilder.requires(obj -> {
            CommandNode commandNode;
            PermissionChecker permissionResolver = this.dispatcher.config().getPermissionChecker();
            Object source = this.wrapCommandSource(obj);
            if (node instanceof CommandNode && ((Command)(commandNode = (CommandNode)node).getData()).isIgnoringACPerms()) {
                return true;
            }
            return permissionResolver.hasPermission(source, node.getPermission());
        });
        this.executor((ArgumentBuilder<?, ?>)childBuilder);
        if (!(node instanceof CommandNode)) {
            ((RequiredArgumentBuilder)childBuilder).suggests(this.createSuggestionProvider((Command)root.getData(), node.getData()));
        }
        if (node.isTrueFlag()) {
            String name = node.getData().name() + "_value";
            ArgumentNode flagValueNode = ParameterNode.createArgumentNode(node, (CommandParameter)CommandParameter.required((String)name, (ParameterType)this.dispatcher.config().getParameterType(node.getData().asFlagParameter().inputValueType())).permission(node.getPermission()).build(), (int)(node.getDepth() + 1), (CommandUsage)node.getExecutableUsage());
            for (ParameterNode trueFlagChildren : node.getChildren()) {
                flagValueNode.addChild(trueFlagChildren);
            }
            childBuilder.then(this.convertNode(root, node, (ParameterNode<S, ?>)flagValueNode));
            return childBuilder.build();
        }
        for (ParameterNode innerChild : node.getChildren()) {
            childBuilder.then(this.convertNode(root, node, innerChild));
        }
        return childBuilder.build();
    }

    @NotNull
    private <T> SuggestionProvider<T> createSuggestionProvider(Command<S> command, CommandParameter<S> parameter) {
        return (context, builder) -> {
            Object source = this.wrapCommandSource(context.getSource());
            String paramFormat = parameter.format();
            String desc = parameter.description() != Description.EMPTY ? parameter.description().toString() : "";
            LiteralMessage tooltip = new LiteralMessage(paramFormat + (String)(desc.isEmpty() ? "" : " - " + desc));
            String input = context.getInput();
            while (input.startsWith("/")) {
                input = input.substring(1);
            }
            int firstSpaceIndex = input.indexOf(32);
            String label = input.substring(0, firstSpaceIndex);
            String argsInput = input.substring(firstSpaceIndex);
            ArgumentInput args = ArgumentInput.parseAutoCompletion((String)argsInput, (boolean)false);
            SuggestionContext ctx = this.dispatcher.config().getContextFactory().createSuggestionContext(this.dispatcher, source, command, label, args);
            CompletionArg arg = ctx.getArgToComplete();
            return this.dispatcher.config().getParameterSuggestionResolver(parameter).asyncAutoComplete(ctx, parameter).thenCompose(arg_0 -> BaseBrigadierManager.lambda$createSuggestionProvider$4(arg, builder, (Message)tooltip, arg_0));
        };
    }

    private void executor(ArgumentBuilder<?, ?> builder) {
        builder.executes(context -> {
            String input = context.getInput();
            Object sender = this.wrapCommandSource(context.getSource());
            this.dispatcher.execute(sender, input);
            return 1;
        });
    }

    @Override
    public <T> void registerArgumentResolver(Class<T> type, ArgumentTypeResolver argumentTypeResolver) {
        this.resolvers.add(param -> {
            if (param.isFlag()) {
                FlagParameter flagParameter = param.asFlagParameter();
                if (flagParameter.isSwitch()) {
                    return argumentTypeResolver.resolveArgType((CommandParameter<?>)flagParameter);
                }
                return param.valueType() == Objects.requireNonNull(flagParameter.flagData().inputType()).type() ? argumentTypeResolver.resolveArgType(param) : null;
            }
            return TypeUtility.matches((Type)param.valueType(), (Type)type) ? argumentTypeResolver.resolveArgType(param) : null;
        });
    }

    @Override
    public void registerArgumentResolver(ArgumentTypeResolver argumentTypeResolver) {
        this.resolvers.add(argumentTypeResolver);
    }

    @Override
    @NotNull
    public ArgumentType<?> getArgumentType(CommandParameter<S> parameter) {
        for (ArgumentTypeResolver resolver : this.resolvers) {
            ArgumentType<?> resolved = resolver.resolveArgType(parameter);
            if (resolved == null) continue;
            return resolved;
        }
        return this.getStringArgType(parameter);
    }

    private StringArgumentType getStringArgType(CommandParameter<S> parameter) {
        if (parameter.isGreedy()) {
            return StringArgumentType.greedyString();
        }
        return StringArgumentType.string();
    }

    private static /* synthetic */ CompletionStage lambda$createSuggestionProvider$4(CompletionArg arg, SuggestionsBuilder builder, Message tooltip, List results) {
        results.stream().filter(c -> arg.isEmpty() || c.toLowerCase().startsWith(arg.value().toLowerCase())).forEachOrdered(res -> builder.suggest(res, tooltip));
        return builder.buildFuture();
    }
}

