/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.BukkitAdventure;
import studio.mevera.imperat.BukkitImperat;
import studio.mevera.imperat.BukkitPermissionChecker;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.ConfigBuilder;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.adventure.AdventureHelpComponent;
import studio.mevera.imperat.adventure.AdventureProvider;
import studio.mevera.imperat.adventure.CastingAdventure;
import studio.mevera.imperat.adventure.EmptyAdventure;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.tree.help.CommandHelp;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.InvalidLocationFormatException;
import studio.mevera.imperat.exception.OnlyConsoleAllowedException;
import studio.mevera.imperat.exception.OnlyPlayerAllowedException;
import studio.mevera.imperat.exception.UnknownOfflinePlayerException;
import studio.mevera.imperat.exception.UnknownPlayerException;
import studio.mevera.imperat.exception.UnknownWorldException;
import studio.mevera.imperat.exception.selector.InvalidSelectorFieldCriteriaFormat;
import studio.mevera.imperat.exception.selector.UnknownEntitySelectionTypeException;
import studio.mevera.imperat.exception.selector.UnknownSelectorFieldException;
import studio.mevera.imperat.resolvers.PermissionChecker;
import studio.mevera.imperat.selector.TargetSelector;
import studio.mevera.imperat.type.ParameterLocation;
import studio.mevera.imperat.type.ParameterOfflinePlayer;
import studio.mevera.imperat.type.ParameterPlayer;
import studio.mevera.imperat.type.ParameterTargetSelector;
import studio.mevera.imperat.util.TypeWrap;
import studio.mevera.imperat.util.reflection.Reflections;

public final class BukkitConfigBuilder
extends ConfigBuilder<BukkitSource, BukkitImperat, BukkitConfigBuilder> {
    private static final BukkitPermissionChecker DEFAULT_PERMISSION_RESOLVER = new BukkitPermissionChecker();
    private final Plugin plugin;
    private AdventureProvider<CommandSender> adventureProvider;
    private boolean supportBrigadier = false;

    BukkitConfigBuilder(Plugin plugin) {
        this.plugin = plugin;
        this.config.setPermissionResolver((PermissionChecker)DEFAULT_PERMISSION_RESOLVER);
        this.addThrowableHandlers();
        this.registerSourceResolvers();
        this.registerValueResolvers();
        this.registerContextResolvers();
    }

    private void registerContextResolvers() {
        this.config.registerContextResolver(new TypeWrap<ExecutionContext<BukkitSource>>(){}.getType(), (ctx, paramElement) -> ctx);
        this.config.registerContextResolver(new TypeWrap<CommandHelp<BukkitSource>>(){}.getType(), (ctx, paramElement) -> CommandHelp.create((ExecutionContext)ctx));
        this.config.registerContextResolver(Plugin.class, (ctx, paramElement) -> this.plugin);
        this.config.registerContextResolver(Server.class, (ctx, paramElement) -> this.plugin.getServer());
    }

    private void registerSourceResolvers() {
        this.config.registerSourceResolver(CommandSender.class, (bukkitSource, ctx) -> bukkitSource.origin());
        this.config.registerSourceResolver(ConsoleCommandSender.class, (bukkitSource, ctx) -> {
            if (!bukkitSource.isConsole()) {
                throw new OnlyConsoleAllowedException(ctx);
            }
            return (ConsoleCommandSender)bukkitSource.origin();
        });
        this.config.registerSourceResolver(Player.class, (source, ctx) -> {
            if (source.isConsole()) {
                throw new OnlyPlayerAllowedException(ctx);
            }
            return source.asPlayer();
        });
    }

    private void addThrowableHandlers() {
        this.config.setThrowableResolver(OnlyPlayerAllowedException.class, (ex, context) -> ((BukkitSource)context.source()).error("Only players can do this!"));
        this.config.setThrowableResolver(OnlyConsoleAllowedException.class, (ex, context) -> ((BukkitSource)context.source()).error("Only console can do this!"));
        this.config.setThrowableResolver(InvalidSelectorFieldCriteriaFormat.class, (ex, context) -> ((BukkitSource)context.source()).error("Invalid field-criteria format '" + ex.getFieldCriteriaInput() + "'"));
        this.config.setThrowableResolver(UnknownSelectorFieldException.class, (ex, context) -> ((BukkitSource)context.source()).error("Unknown selection field '" + ex.getFieldEntered() + "'"));
        this.config.setThrowableResolver(UnknownEntitySelectionTypeException.class, (exception, context) -> ((BukkitSource)context.source()).error("Unknown selection type '" + exception.getInput() + "'"));
        this.config.setThrowableResolver(InvalidLocationFormatException.class, (exception, context) -> {
            InvalidLocationFormatException.Reason reason = exception.getReason();
            String msg = switch (reason) {
                default -> throw new IncompatibleClassChangeError();
                case InvalidLocationFormatException.Reason.INVALID_X_COORDINATE -> "Invalid X coordinate '" + exception.getInputX() + "'";
                case InvalidLocationFormatException.Reason.INVALID_Y_COORDINATE -> "Invalid Y coordinate '" + exception.getInputY() + "'";
                case InvalidLocationFormatException.Reason.INVALID_Z_COORDINATE -> "Invalid Z coordinate '" + exception.getInputZ() + "'";
                case InvalidLocationFormatException.Reason.NO_WORLDS_AVAILABLE -> "Failed to fetch the world of the given location";
                case InvalidLocationFormatException.Reason.WRONG_FORMAT -> "Wrong location format!";
            };
            ((BukkitSource)context.source()).reply("&4Failed to parse location '" + exception.getInput() + "' due to: &c" + msg);
        });
        this.config.setThrowableResolver(UnknownPlayerException.class, (exception, context) -> ((BukkitSource)context.source()).error("A player with the name '" + exception.getName() + "' doesn't seem to be online"));
        this.config.setThrowableResolver(UnknownOfflinePlayerException.class, (exception, context) -> ((BukkitSource)context.source()).error("A player with the name '" + exception.getName() + "' doesn't seem to exist"));
        this.config.setThrowableResolver(UnknownWorldException.class, (exception, context) -> ((BukkitSource)context.source()).error("A world with the name '" + exception.getName() + "' doesn't seem to exist"));
    }

    private void registerValueResolvers() {
        this.config.registerParamType(Player.class, (ParameterType)new ParameterPlayer());
        this.config.registerParamType(OfflinePlayer.class, (ParameterType)new ParameterOfflinePlayer());
        this.config.registerParamType(Location.class, (ParameterType)new ParameterLocation());
        this.config.registerParamType(TargetSelector.class, (ParameterType)new ParameterTargetSelector());
    }

    public void setAdventureProvider(AdventureProvider<CommandSender> adventureProvider) {
        this.adventureProvider = adventureProvider;
    }

    public BukkitConfigBuilder applyBrigadier(boolean supportBrigadier) {
        this.supportBrigadier = supportBrigadier;
        return this;
    }

    @NotNull
    public BukkitImperat build() {
        if (this.adventureProvider == null) {
            this.adventureProvider = this.loadAdventure();
        }
        return new BukkitImperat(this.plugin, this.adventureProvider, this.supportBrigadier, (ImperatConfig<BukkitSource>)this.config);
    }

    @NotNull
    private AdventureProvider<CommandSender> loadAdventure() {
        if (Reflections.findClass((String[])new String[]{"net.kyori.adventure.audience.Audience"})) {
            if (Audience.class.isAssignableFrom(CommandSender.class)) {
                return new CastingAdventure<CommandSender>(){

                    public <SRC extends Source> AdventureHelpComponent<SRC> createHelpComponent(Component component) {
                        return new AdventureHelpComponent(component, (source, comp) -> {
                            if (source instanceof BukkitSource) {
                                BukkitSource bukkitSource = (BukkitSource)source;
                                bukkitSource.reply((ComponentLike)comp);
                            } else {
                                source.reply(comp.toString());
                            }
                        });
                    }
                };
            }
            if (Reflections.findClass((String[])new String[]{"net.kyori.adventure.platform.bukkit.BukkitAudiences"})) {
                return new BukkitAdventure(this.plugin);
            }
        }
        return new EmptyAdventure();
    }
}

