/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import studio.mevera.imperat.AsyncTabListener;
import studio.mevera.imperat.BaseImperat;
import studio.mevera.imperat.BukkitConfigBuilder;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.BukkitUtil;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.InternalBukkitCommand;
import studio.mevera.imperat.Version;
import studio.mevera.imperat.adventure.AdventureProvider;
import studio.mevera.imperat.brigadier.BukkitBrigadierManager;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.resolvers.PermissionChecker;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.StringUtils;

public final class BukkitImperat
extends BaseImperat<BukkitSource> {
    private final Plugin plugin;
    private final boolean paperPlugin;
    private final AdventureProvider<CommandSender> adventureProvider;
    private BukkitBrigadierManager brigadierManager;
    private Map<String, org.bukkit.command.Command> bukkitCommands = new HashMap<String, org.bukkit.command.Command>();

    public static BukkitConfigBuilder builder(Plugin plugin) {
        return new BukkitConfigBuilder(plugin);
    }

    BukkitImperat(Plugin plugin, AdventureProvider<CommandSender> adventureProvider, boolean supportBrigadier, ImperatConfig<BukkitSource> config) {
        super(config);
        this.plugin = plugin;
        this.paperPlugin = this.isPaperPlugin(plugin);
        this.adventureProvider = adventureProvider;
        ImperatDebugger.setLogger((Logger)plugin.getLogger());
        try {
            if (BukkitUtil.KNOWN_COMMANDS != null) {
                this.bukkitCommands = (Map)BukkitUtil.KNOWN_COMMANDS.get(BukkitUtil.COMMAND_MAP);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (supportBrigadier) {
            this.applyBrigadier();
        } else {
            this.applyAsyncTabListener();
        }
    }

    public BukkitSource wrapSender(Object sender) {
        return new BukkitSource((CommandSender)sender, this.adventureProvider);
    }

    public Plugin getPlatform() {
        return this.plugin;
    }

    public void shutdownPlatform() {
        this.adventureProvider.close();
        Bukkit.getPluginManager().disablePlugin(this.plugin);
    }

    public void registerCommand(Command<BukkitSource> command) {
        JavaPlugin javaPlugin;
        PluginCommand existingPluginYamlCmd;
        Plugin plugin;
        super.registerCommand(command);
        if (!this.paperPlugin && (plugin = this.plugin) instanceof JavaPlugin && (existingPluginYamlCmd = (javaPlugin = (JavaPlugin)plugin).getCommand(command.name().toLowerCase())) != null) {
            throw new IllegalArgumentException("Command with name '" + command.name() + "' already exists in plugin.yml!");
        }
        InternalBukkitCommand internalCmd = new InternalBukkitCommand(this, command);
        BukkitUtil.COMMAND_MAP.register(this.plugin.getName(), (org.bukkit.command.Command)internalCmd);
        if (this.brigadierManager != null) {
            this.brigadierManager.registerBukkitCommand(internalCmd, command, (PermissionChecker<BukkitSource>)this.config.getPermissionChecker());
        }
    }

    public void unregisterCommand(String name) {
        Command imperatCmd = this.getCommand(name);
        super.unregisterCommand(name);
        if (imperatCmd == null) {
            return;
        }
        for (Map.Entry<String, org.bukkit.command.Command> entry : new HashSet<Map.Entry<String, org.bukkit.command.Command>>(this.bukkitCommands.entrySet())) {
            String originalKey = entry.getKey();
            String key = StringUtils.stripNamespace((String)originalKey);
            if (!imperatCmd.hasName(key)) continue;
            this.bukkitCommands.remove(originalKey);
        }
        try {
            if (BukkitUtil.KNOWN_COMMANDS != null) {
                BukkitUtil.KNOWN_COMMANDS.set(BukkitUtil.COMMAND_MAP, this.bukkitCommands);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterAllCommands() {
        super.unregisterAllCommands();
        if (BukkitUtil.KNOWN_COMMANDS != null) {
            this.bukkitCommands.clear();
            try {
                BukkitUtil.KNOWN_COMMANDS.set(BukkitUtil.COMMAND_MAP, this.bukkitCommands);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void applyBrigadier() {
        if (Version.isOrOver(13)) {
            this.brigadierManager = BukkitBrigadierManager.load(this);
        }
    }

    private void applyAsyncTabListener() {
        if (Version.SUPPORTS_PAPER_ASYNC_TAB_COMPLETION) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)new AsyncTabListener(this), this.plugin);
        }
    }

    private boolean isPaperPlugin(Plugin plugin) {
        boolean bl;
        if (!Version.IS_PAPER || Version.isOrBelow(13)) {
            return false;
        }
        URI uri = plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        JarFile jar = new JarFile(new File(uri));
        try {
            bl = jar.getEntry("paper-plugin.yml") != null;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | URISyntaxException e) {
                e.printStackTrace();
                return false;
            }
        }
        jar.close();
        return bl;
    }
}

