/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.SimpleCommandMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.BukkitImperat;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.ParameterBuilder;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.reflection.FieldAccessor;
import studio.mevera.imperat.util.reflection.Reflections;

public final class BukkitUtil {
    public static final Pattern PLAYER_USERNAME_PATTERN = Pattern.compile("^[A-Za-z0-9_]{3,16}$");
    public static final Pattern SPLIT_LINE = Pattern.compile(" ", 16);
    public static final FieldAccessor<SimpleCommandMap> COMMAND_MAP_ACCESSOR = Reflections.getField(Bukkit.getServer().getClass(), SimpleCommandMap.class);
    public static CommandMap COMMAND_MAP;
    @Nullable
    public static Field KNOWN_COMMANDS;

    private BukkitUtil() {
    }

    private static void loadBukkitFieldMappings() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        COMMAND_MAP = (CommandMap)COMMAND_MAP_ACCESSOR.get((Object)Bukkit.getServer());
        BukkitUtil.updateCommandActualMap();
    }

    public static void writeCommandMapInstance(SimpleCommandMap commandMap) throws NoSuchFieldException {
        COMMAND_MAP_ACCESSOR.set((Object)Bukkit.getServer(), (Object)commandMap);
        COMMAND_MAP = commandMap;
        BukkitUtil.updateCommandActualMap();
    }

    private static void updateCommandActualMap() throws NoSuchFieldException {
        if (COMMAND_MAP != null) {
            KNOWN_COMMANDS = SimpleCommandMap.class.getDeclaredField("knownCommands");
            KNOWN_COMMANDS.setAccessible(true);
        }
    }

    public static <T> Set<T> mergedSet(Set<T> set1, Set<T> set2, Supplier<Set<T>> supplier) {
        Set<T> merged = supplier.get();
        merged.addAll(set1);
        merged.addAll(set2);
        return merged;
    }

    @ApiStatus.Experimental
    public static Command<BukkitSource> convertBukkitCmdToImperatCmd(Imperat<BukkitSource> imperat, org.bukkit.command.Command bukkitCmd) {
        return Command.create(imperat, (String)bukkitCmd.getName()).aliases(bukkitCmd.getAliases()).description(bukkitCmd.getDescription()).permission(bukkitCmd.getPermission()).usage(CommandUsage.builder().parameters(new ParameterBuilder[]{CommandParameter.requiredGreedy((String)"args")}).execute((source, context) -> {
            String argsOneLine = (String)context.getArgument("args");
            String[] args = SPLIT_LINE.split(argsOneLine);
            bukkitCmd.execute(source.origin(), context.label(), args);
        })).build();
    }

    static {
        try {
            BukkitUtil.loadBukkitFieldMappings();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            ImperatDebugger.error(BukkitImperat.class, (String)"static-init", (Throwable)e, (String)"Failed to fetch bukkit command-map, disabling plugin");
        }
    }

    public static final class ClassesRefUtil {
        private static final String SERVER_VERSION = ClassesRefUtil.getServerVersion();

        private ClassesRefUtil() {
        }

        private static String getServerVersion() {
            Class<?> server = Bukkit.getServer().getClass();
            if (!server.getSimpleName().equals("CraftServer")) {
                return ".";
            }
            if (server.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
                return ".";
            }
            String version = server.getName().substring("org.bukkit.craftbukkit".length());
            return version.substring(0, version.length() - "CraftServer".length());
        }

        public static String mc(String name) {
            return "net.minecraft." + name;
        }

        public static String nms(String className) {
            return "net.minecraft.server" + SERVER_VERSION + className;
        }

        public static Class<?> mcClass(String className) throws ClassNotFoundException {
            return Class.forName(ClassesRefUtil.mc(className));
        }

        public static Class<?> nmsClass(String className) throws ClassNotFoundException {
            return Class.forName(ClassesRefUtil.nms(className));
        }

        public static String obc(String className) {
            return "org.bukkit.craftbukkit" + SERVER_VERSION + className;
        }

        public static Class<?> obcClass(String className) throws ClassNotFoundException {
            return Class.forName(ClassesRefUtil.obc(className));
        }

        public static int minecraftVersion() {
            try {
                Matcher matcher = Pattern.compile("\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?( .*)?\\)").matcher(Bukkit.getVersion());
                if (matcher.find()) {
                    return Integer.parseInt(matcher.toMatchResult().group(2), 10);
                }
                throw new IllegalArgumentException(String.format("No match found in '%s'", Bukkit.getVersion()));
            }
            catch (IllegalArgumentException ex) {
                throw new RuntimeException("Failed to determine Minecraft version", ex);
            }
        }
    }
}

