/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginIdentifiableCommand;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.BukkitImperat;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.Version;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;

@ApiStatus.Internal
final class InternalBukkitCommand
extends org.bukkit.command.Command
implements PluginIdentifiableCommand {
    @NotNull
    private final BukkitImperat dispatcher;
    @NotNull
    final Command<BukkitSource> imperatCommand;

    InternalBukkitCommand(@NotNull BukkitImperat dispatcher, @NotNull Command<BukkitSource> imperatCommand) {
        super(imperatCommand.name(), imperatCommand.description().toString(), CommandUsage.format((String)null, (CommandUsage)imperatCommand.getDefaultUsage()), imperatCommand.aliases());
        this.dispatcher = dispatcher;
        this.imperatCommand = imperatCommand;
    }

    @NotNull
    public Plugin getPlugin() {
        return this.dispatcher.getPlatform();
    }

    @Nullable
    public String getPermission() {
        return this.imperatCommand.tree().rootNode().getPermission();
    }

    @NotNull
    public String getDescription() {
        return super.getDescription();
    }

    @NotNull
    public String getUsage() {
        return super.getUsage();
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] raw) {
        BukkitSource source = this.dispatcher.wrapSender(sender);
        this.dispatcher.execute(source, this.imperatCommand, label, raw);
        return true;
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
        if (Version.SUPPORTS_PAPER_ASYNC_TAB_COMPLETION) {
            return Collections.emptyList();
        }
        BukkitSource source = this.dispatcher.wrapSender(sender);
        StringBuilder builder = new StringBuilder(alias).append(" ");
        for (String arg : args) {
            builder.append(arg).append(" ");
        }
        if (!builder.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return (List)this.dispatcher.autoComplete(source, builder.toString()).join();
    }
}

