/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import org.bukkit.Bukkit;
import studio.mevera.imperat.util.reflection.Reflections;

public final class Version {
    public static final String VERSION_EXACT = Bukkit.getBukkitVersion().split("-")[0];
    public static final boolean IS_FOLIA = Reflections.findClass((String[])new String[]{"io.papermc.paper.threadedregions.RegionizedServer"});
    public static final boolean IS_PAPER = Reflections.findClass((String[])new String[]{"com.destroystokyo.paper.PaperConfig", "io.papermc.paper.configuration.Configuration"});
    public static final boolean SUPPORTS_PAPER_ASYNC_TAB_COMPLETION = Reflections.findClass((String[])new String[]{"com.destroystokyo.paper.event.server.AsyncTabCompleteEvent"});
    public static final int MAJOR;
    public static final int MINOR;
    public static final int PATCH;
    public static final String NMS;
    public static final boolean IS_13_R2_PLUS;
    public static final boolean IS_20_R2_PLUS;
    public static final boolean IS_20_R4_PLUS;

    public static boolean is(int minor) {
        return MINOR == minor;
    }

    public static boolean is(int major, int minor, int patch) {
        return MAJOR == major && MINOR == minor && PATCH == patch;
    }

    public static boolean isOver(int minor) {
        return MINOR > minor;
    }

    public static boolean isOver(int major, int minor, int patch) {
        if (MAJOR > major) {
            return true;
        }
        if (MAJOR == major) {
            if (MINOR > minor) {
                return true;
            }
            if (MINOR == minor) {
                return PATCH > patch;
            }
        }
        return false;
    }

    public static boolean isOrOver(int minor) {
        return MINOR >= minor;
    }

    public static boolean isOrOver(int major, int minor, int patch) {
        return Version.is(major, minor, patch) || Version.isOver(major, minor, patch);
    }

    public static boolean isBelow(int minor) {
        return MINOR < minor;
    }

    public static boolean isBelow(int major, int minor, int patch) {
        if (MAJOR < major) {
            return true;
        }
        if (MAJOR == major) {
            if (MINOR < minor) {
                return true;
            }
            if (MINOR == minor) {
                return PATCH < patch;
            }
        }
        return false;
    }

    public static boolean isOrBelow(int minor) {
        return MINOR <= minor;
    }

    public static boolean isOrBelow(int major, int minor, int patch) {
        return Version.is(major, minor, patch) || Version.isBelow(major, minor, patch);
    }

    private static String findVersion() {
        if (IS_PAPER && MINOR >= 20) {
            return switch (VERSION_EXACT) {
                case "1.20", "1.20.1" -> "1_20_R1";
                case "1.20.2", "1.20.3" -> "1_20_R2";
                case "1.20.4" -> "1_20_R3";
                case "1.20.5", "1.20.6" -> "1_20_R4";
                case "1.21", "1.21.1" -> "1_21_R1";
                case "1.21.2", "1.21.3" -> "1_21_R2";
                case "1.21.4" -> "1_21_R3";
                case "1.21.5" -> "1_21_R4";
                case "1.21.6", "1.21.7" -> "1_21_R5";
                default -> "UNKNOWN";
            };
        }
        return Bukkit.getServer().getClass().getPackage().getName().substring(24);
    }

    static {
        String[] versions = VERSION_EXACT.split("\\.");
        MAJOR = Integer.parseInt(versions[0]);
        MINOR = Integer.parseInt(versions[1]);
        PATCH = versions.length > 2 ? Integer.parseInt(versions[2]) : 0;
        NMS = Version.findVersion();
        IS_13_R2_PLUS = Version.isOrOver(1, 13, 2);
        IS_20_R2_PLUS = Version.isOrOver(1, 20, 2);
        IS_20_R4_PLUS = Version.isOrOver(1, 20, 5);
    }
}

