/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.brigadier;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.BaseBrigadierManager;
import studio.mevera.imperat.BukkitImperat;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.brigadier.DefaultArgTypeResolvers;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.commodore.Commodore;
import studio.mevera.imperat.commodore.CommodoreProvider;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.PermissionChecker;

public final class BukkitBrigadierManager
extends BaseBrigadierManager<BukkitSource> {
    private final Commodore<org.bukkit.command.Command> commodore;

    public BukkitBrigadierManager(BukkitImperat dispatcher) {
        super((Imperat)dispatcher);
        this.commodore = CommodoreProvider.getCommodore(dispatcher.getPlatform());
        if (CommodoreProvider.isSupported()) {
            this.registerArgumentResolver(String.class, DefaultArgTypeResolvers.STRING);
            this.registerArgumentResolver(DefaultArgTypeResolvers.NUMERIC);
            this.registerArgumentResolver(Boolean.class, DefaultArgTypeResolvers.BOOLEAN);
            this.registerArgumentResolver(Player.class, DefaultArgTypeResolvers.PLAYER);
            this.registerArgumentResolver(OfflinePlayer.class, DefaultArgTypeResolvers.PLAYER);
            this.registerArgumentResolver(DefaultArgTypeResolvers.ENTITY_SELECTOR);
        }
    }

    @Nullable
    public static BukkitBrigadierManager load(BukkitImperat bukkitCommandDispatcher) {
        if (!CommodoreProvider.isSupported()) {
            return null;
        }
        return new BukkitBrigadierManager(bukkitCommandDispatcher);
    }

    public BukkitSource wrapCommandSource(Object commandSource) {
        return (BukkitSource)this.dispatcher.wrapSender((Object)this.commodore.wrapNMSCommandSource(commandSource));
    }

    public void registerBukkitCommand(org.bukkit.command.Command bukkitCmd, Command<BukkitSource> imperatCommand, PermissionChecker<BukkitSource> resolver) {
        this.commodore.register(bukkitCmd, this.parseCommandIntoNode(imperatCommand), player -> resolver.hasPermission((Source)((BukkitSource)this.dispatcher.wrapSender(player)), bukkitCmd.getPermission()));
    }
}

