/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.brigadier;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import java.lang.reflect.Type;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.ArgumentTypeResolver;
import studio.mevera.imperat.brigadier.MinecraftArgumentType;
import studio.mevera.imperat.command.parameters.NumericRange;
import studio.mevera.imperat.selector.TargetSelector;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeWrap;

class DefaultArgTypeResolvers {
    private static final ArgumentType<?> SINGLE_PLAYER = DefaultArgTypeResolvers.entity(true, true);
    private static final ArgumentType<?> MULTI_ENTITY = DefaultArgTypeResolvers.entity(false, false);
    public static final ArgumentTypeResolver STRING = parameter -> {
        if (parameter.isGreedy()) {
            return StringArgumentType.greedyString();
        }
        return StringArgumentType.string();
    };
    public static final ArgumentTypeResolver BOOLEAN = parameter -> BoolArgumentType.bool();
    public static final ArgumentTypeResolver NUMERIC = parameter -> {
        if (parameter.isNumeric()) {
            NumericRange range = parameter.asNumeric().getRange();
            return DefaultArgTypeResolvers.numeric(parameter.valueType(), range);
        }
        return null;
    };
    public static final ArgumentTypeResolver PLAYER = parameter -> SINGLE_PLAYER;
    public static final ArgumentTypeResolver ENTITY_SELECTOR = parameter -> {
        if (TypeUtility.matches((Type)parameter.valueType(), TargetSelector.class) || TypeWrap.of(Entity.class).isSupertypeOf(parameter.valueType())) {
            return MULTI_ENTITY;
        }
        return null;
    };

    DefaultArgTypeResolvers() {
    }

    private static ArgumentType<? extends Number> numeric(Type type, @Nullable NumericRange range) {
        if (TypeUtility.matches((Type)type, Integer.TYPE)) {
            return IntegerArgumentType.integer((int)((int)DefaultArgTypeResolvers.getMin(range)), (int)((int)DefaultArgTypeResolvers.getMax(range)));
        }
        if (TypeUtility.matches((Type)type, Long.TYPE)) {
            return LongArgumentType.longArg((long)((long)DefaultArgTypeResolvers.getMin(range)), (long)((long)DefaultArgTypeResolvers.getMax(range)));
        }
        if (TypeUtility.matches((Type)type, Float.TYPE)) {
            return FloatArgumentType.floatArg((float)((float)DefaultArgTypeResolvers.getMin(range)), (float)((float)DefaultArgTypeResolvers.getMax(range)));
        }
        if (TypeUtility.matches((Type)type, Double.TYPE)) {
            return DoubleArgumentType.doubleArg((double)DefaultArgTypeResolvers.getMin(range), (double)DefaultArgTypeResolvers.getMax(range));
        }
        throw new IllegalArgumentException("Unsupported numeric valueType: " + String.valueOf(type));
    }

    private static double getMin(@Nullable NumericRange range) {
        if (range == null) {
            return Double.MIN_VALUE;
        }
        return range.getMin();
    }

    private static double getMax(@Nullable NumericRange range) {
        if (range == null) {
            return Double.MAX_VALUE;
        }
        return range.getMax();
    }

    private static ArgumentType<?> entity(boolean single, boolean playerOnly) {
        return MinecraftArgumentType.ENTITY.create(single, playerOnly);
    }
}

