/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.commodore;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import studio.mevera.imperat.BukkitUtil;
import studio.mevera.imperat.commodore.Commodore;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.Preconditions;

abstract class AbstractCommodore
implements Commodore<Command> {
    protected static final Field CUSTOM_SUGGESTIONS_FIELD;
    protected static final Field COMMAND_EXECUTE_FUNCTION_FIELD;
    protected static final Field CHILDREN_FIELD;
    protected static final Field LITERALS_FIELD;
    protected static final Field ARGUMENTS_FIELD;
    protected static final Field[] CHILDREN_FIELDS;
    protected static final com.mojang.brigadier.Command<?> DUMMY_COMMAND;
    protected static final SuggestionProvider<?> DUMMY_SUGGESTION_PROVIDER;
    private static final Method GET_COMMAND_SENDER_METHOD;

    AbstractCommodore() {
    }

    protected static void removeChild(RootCommandNode root, String name) {
        try {
            for (Field field : CHILDREN_FIELDS) {
                Map children = (Map)field.get(root);
                children.remove(name);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void setRequiredHackyFieldsRecursively(CommandNode<?> node, SuggestionProvider<?> suggestionProvider) {
        try {
            COMMAND_EXECUTE_FUNCTION_FIELD.set(node, DUMMY_COMMAND);
        }
        catch (IllegalAccessException e) {
            ImperatDebugger.error(AbstractCommodore.class, (String)"static<init>", (Throwable)e);
        }
        if (suggestionProvider != null && node instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentNode = (ArgumentCommandNode)node;
            try {
                CUSTOM_SUGGESTIONS_FIELD.set(argumentNode, suggestionProvider);
            }
            catch (IllegalAccessException e) {
                ImperatDebugger.error(AbstractCommodore.class, (String)"static<init>", (Throwable)e);
            }
        }
        for (CommandNode child : node.getChildren()) {
            AbstractCommodore.setRequiredHackyFieldsRecursively(child, suggestionProvider);
        }
    }

    protected static <S> LiteralCommandNode<S> renameLiteralNode(LiteralCommandNode<S> node, String newLiteral) {
        LiteralCommandNode clone = new LiteralCommandNode(newLiteral, node.getCommand(), node.getRequirement(), node.getRedirect(), node.getRedirectModifier(), node.isFork());
        for (CommandNode child : node.getChildren()) {
            clone.addChild(child);
        }
        return clone;
    }

    protected static Collection<String> getAliases(Command command) {
        if (command == null) {
            return Collections.emptyList();
        }
        Stream<String> aliasesStream = Stream.concat(Stream.of(command.getLabel()), command.getAliases().stream());
        if (command instanceof PluginCommand) {
            String fallbackPrefix = ((PluginCommand)command).getPlugin().getName().toLowerCase().trim();
            aliasesStream = aliasesStream.flatMap(alias -> Stream.of(alias, fallbackPrefix + ":" + alias));
        }
        return aliasesStream.distinct().collect(Collectors.toList());
    }

    @Override
    public CommandSender wrapNMSCommandSource(Object nmsCmdSource) {
        Preconditions.notNull((Object)nmsCmdSource, (String)"Source from NMS ");
        try {
            return (CommandSender)GET_COMMAND_SENDER_METHOD.invoke(nmsCmdSource, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Class<?> commandListenerWrapper = BukkitUtil.ClassesRefUtil.minecraftVersion() > 16 ? BukkitUtil.ClassesRefUtil.mcClass("commands.CommandListenerWrapper") : BukkitUtil.ClassesRefUtil.nmsClass("CommandListenerWrapper");
            CUSTOM_SUGGESTIONS_FIELD = ArgumentCommandNode.class.getDeclaredField("customSuggestions");
            CUSTOM_SUGGESTIONS_FIELD.setAccessible(true);
            COMMAND_EXECUTE_FUNCTION_FIELD = CommandNode.class.getDeclaredField("command");
            COMMAND_EXECUTE_FUNCTION_FIELD.setAccessible(true);
            CHILDREN_FIELD = CommandNode.class.getDeclaredField("children");
            LITERALS_FIELD = CommandNode.class.getDeclaredField("literals");
            ARGUMENTS_FIELD = CommandNode.class.getDeclaredField("arguments");
            for (Field field : CHILDREN_FIELDS = new Field[]{CHILDREN_FIELD, LITERALS_FIELD, ARGUMENTS_FIELD}) {
                field.setAccessible(true);
            }
            GET_COMMAND_SENDER_METHOD = commandListenerWrapper.getDeclaredMethod("getBukkitSender", new Class[0]);
            GET_COMMAND_SENDER_METHOD.setAccessible(true);
            DUMMY_COMMAND = ctx -> {
                throw new UnsupportedOperationException();
            };
            DUMMY_SUGGESTION_PROVIDER = (context, builder) -> {
                throw new UnsupportedOperationException();
            };
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

