/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.commodore;

import java.util.Objects;
import org.bukkit.command.Command;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.commodore.BrigadierUnsupportedException;
import studio.mevera.imperat.commodore.Commodore;
import studio.mevera.imperat.commodore.LegacyPaperCommodore;
import studio.mevera.imperat.commodore.ModernPaperCommodore;
import studio.mevera.imperat.commodore.ReflectionCommodore;
import studio.mevera.imperat.util.ImperatDebugger;

public final class CommodoreProvider {
    private static boolean SUPPORTED;

    private CommodoreProvider() {
        throw new AssertionError();
    }

    @Nullable
    private static Commodore<Command> load(Plugin plugin) {
        if (!SUPPORTED) {
            return null;
        }
        try {
            return new ModernPaperCommodore(plugin);
        }
        catch (Throwable e) {
            CommodoreProvider.printDebugInfo(e);
            try {
                return new LegacyPaperCommodore(plugin);
            }
            catch (Throwable e2) {
                ImperatDebugger.warning((String)"Paper not found, falling back to Reflection for brigadier", (Object[])new Object[0]);
                try {
                    ReflectionCommodore.ensureSetup();
                    return new ReflectionCommodore(plugin);
                }
                catch (Throwable e3) {
                    CommodoreProvider.printDebugInfo(e3);
                    return null;
                }
            }
        }
    }

    private static void printDebugInfo(Throwable e) {
        if (System.getProperty("commodore.visualize") != null) {
            System.err.println("Exception while initialising commodore:");
            e.printStackTrace(System.err);
        }
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    public static Commodore<Command> getCommodore(Plugin plugin) throws BrigadierUnsupportedException {
        Objects.requireNonNull(plugin, "plugin");
        Commodore<Command> commodore = CommodoreProvider.load(plugin);
        if (commodore == null) {
            throw new BrigadierUnsupportedException("Brigadier is not supported by the server. Set -Dcommodore.visualize=true for visualize info.");
        }
        return commodore;
    }

    static {
        try {
            Class.forName("com.mojang.brigadier.CommandDispatcher");
            SUPPORTED = true;
        }
        catch (Throwable e) {
            CommodoreProvider.printDebugInfo(e);
            SUPPORTED = false;
        }
    }
}

