/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.commodore;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import studio.mevera.imperat.commodore.AbstractCommodore;

final class LegacyPaperCommodore
extends AbstractCommodore
implements Listener {
    private final List<CommodoreCommand> commands = new ArrayList<CommodoreCommand>();

    LegacyPaperCommodore(Plugin plugin) throws ClassNotFoundException {
        Class.forName("com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void register(LiteralCommandNode<?> node) {
        Objects.requireNonNull(node, "node");
        this.commands.add(new CommodoreCommand(node, null));
    }

    @Override
    public void register(Command command, LiteralCommandNode<?> node, Predicate<? super Player> permissionTest) {
        Objects.requireNonNull(command, "command");
        Objects.requireNonNull(node, "node");
        Objects.requireNonNull(permissionTest, "permissionTest");
        try {
            LegacyPaperCommodore.setRequiredHackyFieldsRecursively(node, DUMMY_SUGGESTION_PROVIDER);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Collection<String> aliases = LegacyPaperCommodore.getAliases(command);
        if (!aliases.contains(node.getLiteral())) {
            node = LegacyPaperCommodore.renameLiteralNode(node, command.getName());
        }
        for (String alias : aliases) {
            if (node.getLiteral().equals(alias)) {
                this.commands.add(new CommodoreCommand(node, permissionTest));
                continue;
            }
            LiteralCommandNode redirectNode = ((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).redirect(node)).build();
            this.commands.add(new CommodoreCommand(redirectNode, permissionTest));
        }
    }

    @EventHandler
    public void onPlayerSendCommandsEvent(AsyncPlayerSendCommandsEvent<?> event) {
        if (event.isAsynchronous() || !event.hasFiredAsync()) {
            for (CommodoreCommand command : this.commands) {
                command.apply(event.getPlayer(), event.getCommandNode());
            }
        }
    }

    private record CommodoreCommand(LiteralCommandNode<?> node, Predicate<? super Player> permissionTest) {
        public void apply(Player player, RootCommandNode<?> root) {
            if (this.permissionTest != null && !this.permissionTest.test((Player)player)) {
                return;
            }
            AbstractCommodore.removeChild(root, this.node.getName());
            root.addChild(this.node);
        }
    }
}

