/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector;

import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.selector.SelectionType;

public final class TargetSelector
implements Iterable<Entity> {
    private final SelectionType type;
    private final List<Entity> selectedEntities;

    private TargetSelector(SelectionType type, List<Entity> selectedEntities) {
        this.type = type;
        this.selectedEntities = selectedEntities;
    }

    public static TargetSelector of(SelectionType type, List<Entity> list) {
        return new TargetSelector(type, list);
    }

    public static TargetSelector of(SelectionType type, Entity ... list) {
        return TargetSelector.of(type, List.of(list));
    }

    public static TargetSelector empty() {
        return TargetSelector.of(SelectionType.UNKNOWN, List.of());
    }

    @Override
    @NotNull
    public Iterator<Entity> iterator() {
        return this.selectedEntities.iterator();
    }

    public SelectionType getType() {
        return this.type;
    }

    public int size() {
        return this.selectedEntities.size();
    }

    public boolean isEmpty() {
        return this.selectedEntities.isEmpty();
    }

    public boolean containsExactly(Entity ... entities) {
        if (entities.length != this.selectedEntities.size()) {
            return false;
        }
        for (Entity entity : entities) {
            if (this.selectedEntities.contains(entity)) continue;
            return false;
        }
        return true;
    }

    public <E extends Entity> List<E> only(Class<E> type) {
        return this.selectedEntities.stream().filter(type::isInstance).map(type::cast).toList();
    }
}

