/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class Range<N extends Number>
extends Number {
    @Nullable
    private final N min;
    @Nullable
    private final N max;

    private Range(@Nullable N min, @Nullable N max) {
        this.min = min;
        this.max = max;
    }

    public static <N extends Number> Range<N> atLeast(N numericValue) {
        return Range.of(numericValue, null);
    }

    public static <N extends Number> Range<N> atMost(N numericValue) {
        return Range.of(null, numericValue);
    }

    @Nullable
    public N getMax() {
        return this.max;
    }

    @Nullable
    public N getMin() {
        return this.min;
    }

    public static <N extends Number> Range<N> of(@Nullable N min, @Nullable N max) {
        return new Range<N>(min, max);
    }

    public boolean isInRange(N value) {
        if (value instanceof Range) {
            Range other = (Range)value;
            return this.equals(other);
        }
        if (this.min == null) {
            if (this.max == null) {
                return true;
            }
            return ((Number)value).doubleValue() <= ((Number)this.max).doubleValue();
        }
        if (this.max == null) {
            return ((Number)value).doubleValue() >= ((Number)this.min).doubleValue();
        }
        return ((Number)value).doubleValue() >= ((Number)this.min).doubleValue() && ((Number)value).doubleValue() <= ((Number)this.max).doubleValue();
    }

    @Override
    public int intValue() {
        if (this.min != null) {
            return ((Number)this.min).intValue();
        }
        if (this.max != null) {
            return ((Number)this.max).intValue();
        }
        return 0;
    }

    @Override
    public long longValue() {
        if (this.min != null) {
            return ((Number)this.min).longValue();
        }
        if (this.max != null) {
            return ((Number)this.max).longValue();
        }
        return 0L;
    }

    @Override
    public float floatValue() {
        if (this.min != null) {
            return ((Number)this.min).floatValue();
        }
        if (this.max != null) {
            return ((Number)this.max).floatValue();
        }
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        if (this.min != null) {
            return ((Number)this.min).doubleValue();
        }
        if (this.max != null) {
            return ((Number)this.max).doubleValue();
        }
        return 0.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return Objects.equals(this.min, range.min) && Objects.equals(this.max, range.max);
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }
}

