/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field;

import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.SourceException;
import studio.mevera.imperat.selector.field.AbstractField;
import studio.mevera.imperat.selector.field.NumericField;
import studio.mevera.imperat.selector.field.Range;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeWrap;

public final class RangedNumericField<N extends Number>
extends AbstractField<Range<N>> {
    private static final String RANGE_CHARACTER = "\\.\\.";
    private static final String RANGE_CHARACTER_WITHOUT_ESCAPE = "..";
    private final NumericField<N> numericField;

    private RangedNumericField(NumericField<N> numericField) {
        super(numericField.name, new TypeWrap<Range<N>>(){});
        this.numericField = numericField;
    }

    public static <N extends Number> RangedNumericField<N> of(NumericField<N> numericField) {
        return new RangedNumericField<N>(numericField);
    }

    @Override
    public Range<N> parseFieldValue(String value, Context<BukkitSource> context) throws ImperatException {
        if (!value.contains(RANGE_CHARACTER_WITHOUT_ESCAPE)) {
            N numericValue = this.numericField.parseNumber(value, context);
            return Range.atLeast(numericValue);
        }
        if (value.startsWith(RANGE_CHARACTER_WITHOUT_ESCAPE)) {
            N rangeValue = this.numericField.parseNumber(value.replace(RANGE_CHARACTER_WITHOUT_ESCAPE, ""), context);
            return Range.atLeast(rangeValue);
        }
        if (value.endsWith(RANGE_CHARACTER_WITHOUT_ESCAPE)) {
            N rangeValue = this.numericField.parseNumber(value.replace(RANGE_CHARACTER_WITHOUT_ESCAPE, ""), context);
            return Range.atMost(rangeValue);
        }
        String[] minMaxSplit = value.split(RANGE_CHARACTER);
        if (minMaxSplit.length > 2) {
            throw new SourceException(context, "Invalid distance range format '%s'", new Object[]{value});
        }
        String minStr = minMaxSplit[0];
        String maxStr = minMaxSplit[1];
        if (!TypeUtility.isNumber((String)minStr)) {
            throw new SourceException(context, "Invalid min-value '%s'", new Object[]{minStr});
        }
        if (!TypeUtility.isNumber((String)maxStr)) {
            throw new SourceException(context, "Invalid max-value '%s'", new Object[]{maxStr});
        }
        Object min = this.numericField.parseFieldValue(minStr, (Context)context);
        Object max = this.numericField.parseFieldValue(maxStr, (Context)context);
        return Range.of(min, max);
    }
}

