/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field.filters;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.SourceException;
import studio.mevera.imperat.selector.EntityCondition;
import studio.mevera.imperat.selector.field.NumericField;
import studio.mevera.imperat.selector.field.Range;
import studio.mevera.imperat.selector.field.RangedNumericField;
import studio.mevera.imperat.selector.field.filters.PredicateField;
import studio.mevera.imperat.util.TypeWrap;

final class DistanceField
extends PredicateField<Range<Double>> {
    private final RangedNumericField<Double> rangedNumericField;

    DistanceField(String name) {
        super(name, new TypeWrap<Range<Double>>(){});
        this.rangedNumericField = RangedNumericField.of(NumericField.doubleField(name));
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(Range<Double> value, CommandInputStream<BukkitSource> commandInputStream, Context<BukkitSource> context) {
        return (sender, entity) -> {
            if (sender.isConsole()) {
                throw new SourceException(context, "Only players can use the field=`distance`", new Object[0]);
            }
            Player commandSource = sender.asPlayer();
            double diffInDistance = commandSource.getLocation().distance(entity.getLocation());
            return value.isInRange(diffInDistance);
        };
    }

    @Override
    public Range<Double> parseFieldValue(String value, Context<BukkitSource> context) throws ImperatException {
        return this.rangedNumericField.parseFieldValue(value, (Context)context);
    }
}

