/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field.filters;

import java.util.Arrays;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.SourceException;
import studio.mevera.imperat.selector.EntityCondition;
import studio.mevera.imperat.selector.field.filters.PredicateField;
import studio.mevera.imperat.util.TypeWrap;

final class GamemodeField
extends PredicateField<GameMode> {
    GamemodeField(String name) {
        super(name, TypeWrap.of(GameMode.class));
        Arrays.stream(GameMode.values()).map(Enum::name).map(String::toLowerCase).forEach(this.suggestions::add);
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(GameMode value, CommandInputStream<BukkitSource> commandInputStream, Context<BukkitSource> context) {
        return (sender, entity) -> {
            if (!(entity instanceof HumanEntity)) {
                return false;
            }
            HumanEntity humanEntity = (HumanEntity)entity;
            return humanEntity.getGameMode() == value;
        };
    }

    @Override
    public GameMode parseFieldValue(String value, Context<BukkitSource> context) throws ImperatException {
        try {
            return GameMode.valueOf((String)value);
        }
        catch (EnumConstantNotPresentException ex) {
            throw new SourceException(context, "Unknown gamemode '%s'", new Object[]{value});
        }
    }
}

