/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field.filters;

import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.selector.EntityCondition;
import studio.mevera.imperat.selector.field.NumericField;
import studio.mevera.imperat.selector.field.Range;
import studio.mevera.imperat.selector.field.RangedNumericField;
import studio.mevera.imperat.selector.field.filters.PredicateField;
import studio.mevera.imperat.util.TypeWrap;

final class LevelField
extends PredicateField<Range<Integer>> {
    private final RangedNumericField<Integer> numericField;

    LevelField(String name) {
        super(name, new TypeWrap<Range<Integer>>(){});
        this.numericField = RangedNumericField.of(NumericField.integerField(name));
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(Range<Integer> value, CommandInputStream<BukkitSource> commandInputStream, Context<BukkitSource> context) {
        return (sender, entity) -> {
            if (!(entity instanceof Player)) {
                return false;
            }
            Player humanEntity = (Player)entity;
            return value.isInRange(humanEntity.getLevel());
        };
    }

    @Override
    public Range<Integer> parseFieldValue(String value, Context<BukkitSource> context) throws ImperatException {
        return this.numericField.parseFieldValue(value, (Context)context);
    }
}

