/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field.filters;

import java.util.Arrays;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.SourceException;
import studio.mevera.imperat.selector.EntityCondition;
import studio.mevera.imperat.selector.field.filters.PredicateField;
import studio.mevera.imperat.util.TypeWrap;

final class TypeField
extends PredicateField<EntityType> {
    TypeField(String name) {
        super(name, TypeWrap.of(EntityType.class));
        Arrays.stream(EntityType.values()).map(Enum::name).map(String::toLowerCase).forEach(this.suggestions::add);
    }

    @Override
    @NotNull
    protected EntityCondition getCondition(EntityType value, CommandInputStream<BukkitSource> commandInputStream, Context<BukkitSource> context) {
        return (sender, entity) -> entity.getType() == value;
    }

    @Override
    public EntityType parseFieldValue(String value, Context<BukkitSource> context) throws ImperatException {
        try {
            return EntityType.valueOf((String)value.toUpperCase());
        }
        catch (EnumConstantNotPresentException ex) {
            throw new SourceException(context, "Unknown entity-type '%s'", new Object[]{value});
        }
    }
}

