/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field.operators;

import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Entity;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.SourceException;
import studio.mevera.imperat.selector.field.operators.OperatorField;
import studio.mevera.imperat.selector.field.operators.SortOption;
import studio.mevera.imperat.util.TypeWrap;

final class SortOperatorField
extends OperatorField<SortOption> {
    SortOperatorField(String name) {
        super(name, TypeWrap.of(SortOption.class));
        Arrays.stream(SortOption.values()).map(Enum::name).map(String::toLowerCase).forEach(this.suggestions::add);
    }

    @Override
    public SortOption parseFieldValue(String value, Context<BukkitSource> context) throws ImperatException {
        for (SortOption option : SortOption.values()) {
            if (!option.name().equalsIgnoreCase(this.name)) continue;
            return option;
        }
        throw new SourceException(context, "Unknown sort option '%s'", new Object[]{this.name});
    }

    @Override
    public void operate(SortOption value, List<Entity> entities) {
        value.sort(entities);
    }
}

