/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.selector.field.operators;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.bukkit.entity.Entity;

public enum SortOption {
    NEAREST(Comparator.comparingDouble(e -> e.getLocation().distanceSquared(e.getLocation()))),
    FURTHEST((e1, e2) -> Double.compare(e2.getLocation().distanceSquared(e2.getLocation()), e1.getLocation().distanceSquared(e1.getLocation()))),
    RANDOM(Comparator.comparing(e -> Math.random())),
    ARBITRARY(null);

    private static final Random RANDOM_GENERATOR;
    private final Comparator<Entity> comparator;

    private SortOption(Comparator<Entity> comparator) {
        this.comparator = comparator;
    }

    void sort(List<Entity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        if (this == RANDOM) {
            Collections.shuffle(entities, RANDOM_GENERATOR);
            return;
        }
        if (this.comparator != null) {
            entities.sort(this.comparator);
        }
    }

    static {
        RANDOM_GENERATOR = new Random();
    }
}

