/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.type;

import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.InvalidLocationFormatException;
import studio.mevera.imperat.exception.UnknownWorldException;
import studio.mevera.imperat.util.TypeUtility;

public class ParameterLocation
extends BaseParameterType<BukkitSource, Location> {
    private static final String SINGLE_STRING_SEPARATOR = ";";
    private final ParameterType<BukkitSource, Double> doubleParser = ParameterTypes.numeric(Double.class);

    @Nullable
    public Location resolve(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> stream, @NotNull String input) throws ImperatException {
        try {
            String currentRaw = (String)stream.currentRaw().orElseThrow();
            return this.locFromStr(context, stream, currentRaw);
        }
        catch (Exception ex) {
            World world;
            String currentRaw = (String)stream.currentRaw().orElseThrow();
            if (!TypeUtility.isNumber((String)currentRaw) && Bukkit.getWorld((String)currentRaw) != null) {
                world = Bukkit.getWorld((String)currentRaw);
                stream.skipRaw();
            } else if (((BukkitSource)context.source()).isConsole()) {
                List worlds = Bukkit.getWorlds();
                if (worlds.isEmpty()) {
                    throw new InvalidLocationFormatException(input, InvalidLocationFormatException.Reason.NO_WORLDS_AVAILABLE, (Context<?>)context);
                }
                world = (World)Bukkit.getWorlds().get(0);
            } else {
                world = ((BukkitSource)context.source()).asPlayer().getWorld();
            }
            ParameterType doubleParser = context.imperatConfig().getParameterType(Double.class);
            if (doubleParser == null) {
                throw new IllegalArgumentException("Failed to find a parser for type '" + Double.class.getTypeName() + "'");
            }
            String inputX = stream.readInput();
            Double x = (Double)doubleParser.resolve(context, stream, inputX);
            if (x == null) {
                throw new InvalidLocationFormatException(input, InvalidLocationFormatException.Reason.INVALID_X_COORDINATE, inputX, null, null, (Context<?>)context);
            }
            stream.skipRaw();
            String inputY = stream.readInput();
            Double y = (Double)doubleParser.resolve(context, stream, inputY);
            if (y == null) {
                throw new InvalidLocationFormatException(input, InvalidLocationFormatException.Reason.INVALID_Y_COORDINATE, null, inputY, null, (Context<?>)context);
            }
            stream.skipRaw();
            String inputZ = stream.readInput();
            Double z = (Double)doubleParser.resolve(context, stream, inputZ);
            if (z == null) {
                throw new InvalidLocationFormatException(input, InvalidLocationFormatException.Reason.INVALID_Z_COORDINATE, null, null, inputZ, (Context<?>)context);
            }
            return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
        }
    }

    @NotNull
    private Location locFromStr(ExecutionContext<BukkitSource> context, CommandInputStream<BukkitSource> stream, String currentRaw) throws ImperatException {
        String[] split = currentRaw.split(SINGLE_STRING_SEPARATOR);
        if (split.length < 4) {
            throw new InvalidLocationFormatException(currentRaw, InvalidLocationFormatException.Reason.WRONG_FORMAT, (Context<?>)context);
        }
        World world = Bukkit.getWorld((String)split[0]);
        if (world == null) {
            throw new UnknownWorldException(split[0], (Context<BukkitSource>)context);
        }
        Double x = Objects.requireNonNull((Double)this.doubleParser.resolve(context, stream, split[1]));
        Double y = Objects.requireNonNull((Double)this.doubleParser.resolve(context, stream, split[2]));
        Double z = Objects.requireNonNull((Double)this.doubleParser.resolve(context, stream, split[3]));
        return new Location(world, x.doubleValue(), y.doubleValue(), z.doubleValue());
    }

    public boolean isGreedy(CommandParameter<BukkitSource> parameter) {
        return true;
    }
}

