/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.type;

import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.UnknownPlayerException;
import studio.mevera.imperat.resolvers.SuggestionResolver;

public class ParameterOfflinePlayer
extends BaseParameterType<BukkitSource, OfflinePlayer> {
    private final PlayerSuggestionResolver playerSuggestionResolver = new PlayerSuggestionResolver();

    @Nullable
    public OfflinePlayer resolve(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream, @NotNull String input) throws ImperatException {
        if (input.length() > 16) {
            throw new UnknownPlayerException(input, (Context<BukkitSource>)context);
        }
        return Bukkit.getOfflinePlayer((String)input);
    }

    public SuggestionResolver<BukkitSource> getSuggestionResolver() {
        return this.playerSuggestionResolver;
    }

    private static final class PlayerSuggestionResolver
    implements SuggestionResolver<BukkitSource> {
        private PlayerSuggestionResolver() {
        }

        public List<String> autoComplete(SuggestionContext<BukkitSource> context, CommandParameter<BukkitSource> parameter) {
            return Arrays.stream(Bukkit.getOfflinePlayers()).map(OfflinePlayer::getName).toList();
        }
    }
}

