/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.type;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.BukkitUtil;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.UnknownPlayerException;
import studio.mevera.imperat.resolvers.SuggestionResolver;

public class ParameterPlayer
extends BaseParameterType<BukkitSource, Player> {
    private final PlayerSuggestionResolver SUGGESTION_RESOLVER = new PlayerSuggestionResolver();
    private final OptionalValueSupplier DEFAULT_VALUE_SUPPLIER = OptionalValueSupplier.of((String)"~");

    @Nullable
    public Player resolve(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream, @NotNull String input) throws ImperatException {
        if (input.equalsIgnoreCase("me") || input.equalsIgnoreCase("~")) {
            if (((BukkitSource)context.source()).isConsole()) {
                throw new UnknownPlayerException(input, (Context<BukkitSource>)context);
            }
            return ((BukkitSource)context.source()).asPlayer();
        }
        Player player = Bukkit.getPlayerExact((String)input);
        if (player != null) {
            return player;
        }
        throw new UnknownPlayerException(input, (Context<BukkitSource>)context);
    }

    public SuggestionResolver<BukkitSource> getSuggestionResolver() {
        return this.SUGGESTION_RESOLVER;
    }

    public OptionalValueSupplier supplyDefaultValue() {
        return this.DEFAULT_VALUE_SUPPLIER;
    }

    public boolean matchesInput(int rawPosition, Context<BukkitSource> context, CommandParameter<BukkitSource> parameter) {
        String input = (String)context.arguments().get(rawPosition);
        if (input == null) {
            return false;
        }
        return BukkitUtil.PLAYER_USERNAME_PATTERN.matcher(input).matches() && Bukkit.getPlayer((String)input) != null;
    }

    private static final class PlayerSuggestionResolver
    implements SuggestionResolver<BukkitSource> {
        private PlayerSuggestionResolver() {
        }

        public List<String> autoComplete(SuggestionContext<BukkitSource> context, CommandParameter<BukkitSource> parameter) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
        }
    }
}

