/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.type;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.BukkitSource;
import studio.mevera.imperat.Version;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.selector.UnknownEntitySelectionTypeException;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.selector.EntityCondition;
import studio.mevera.imperat.selector.SelectionParameterInput;
import studio.mevera.imperat.selector.SelectionType;
import studio.mevera.imperat.selector.TargetSelector;
import studio.mevera.imperat.selector.field.filters.PredicateField;
import studio.mevera.imperat.selector.field.operators.OperatorField;

public final class ParameterTargetSelector
extends BaseParameterType<BukkitSource, TargetSelector> {
    private static final char PARAMETER_START = '[';
    private static final char PARAMETER_END = ']';
    private final SuggestionResolver<BukkitSource> suggestionResolver;

    public ParameterTargetSelector() {
        SelectionType.TYPES.stream().filter(type -> type != SelectionType.UNKNOWN).map(SelectionType::id).forEach(id -> this.suggestions.add("@" + id));
        this.suggestionResolver = new TargetSelectorSuggestionResolver();
    }

    @NotNull
    public TargetSelector resolve(@NotNull ExecutionContext<BukkitSource> context, @NotNull CommandInputStream<BukkitSource> commandInputStream, @NotNull String input) throws ImperatException {
        boolean parameterized;
        String raw = commandInputStream.currentRaw().orElse(null);
        if (raw == null) {
            return TargetSelector.empty();
        }
        if (Version.isOrOver(13)) {
            SelectionType type = commandInputStream.popLetter().map(s -> SelectionType.from(String.valueOf(s))).orElse(SelectionType.UNKNOWN);
            return TargetSelector.of(type, Bukkit.selectEntities((CommandSender)((BukkitSource)context.source()).origin(), (String)raw));
        }
        char last = raw.charAt(raw.length() - 1);
        if (commandInputStream.currentLetter().filter(c -> String.valueOf(c).equalsIgnoreCase("@")).isEmpty()) {
            Player target = Bukkit.getPlayer((String)raw);
            if (target == null) {
                return TargetSelector.empty();
            }
            return TargetSelector.of(SelectionType.UNKNOWN, new Entity[]{target});
        }
        SelectionType type = commandInputStream.popLetter().map(s -> SelectionType.from(String.valueOf(s))).orElse(SelectionType.UNKNOWN);
        if (type == SelectionType.UNKNOWN) {
            throw new UnknownEntitySelectionTypeException(String.valueOf(commandInputStream.currentLetter().orElseThrow()), (Context<?>)context);
        }
        List<SelectionParameterInput<?>> inputParameters = new ArrayList();
        boolean bl = parameterized = commandInputStream.popLetter().map(c -> c.charValue() == '[').orElse(false) != false && last == ']';
        if (parameterized) {
            commandInputStream.skipLetter();
            String params = commandInputStream.collectBeforeFirst(']');
            inputParameters = SelectionParameterInput.parseAll(params, commandInputStream, context);
        }
        List entities = type.getTargetEntities(context, commandInputStream);
        ArrayList<Entity> selected = new ArrayList<Entity>();
        EntityCondition entityPredicted = ParameterTargetSelector.getEntityPredicate(commandInputStream, inputParameters, context);
        for (Entity entity : entities) {
            if (!entityPredicted.test((BukkitSource)context.source(), entity)) continue;
            selected.add(entity);
        }
        ParameterTargetSelector.operateFields(inputParameters, selected);
        return TargetSelector.of(type, selected);
    }

    @NotNull
    private static <V> EntityCondition getEntityPredicate(@NotNull CommandInputStream<BukkitSource> commandInputStream, List<SelectionParameterInput<?>> inputParameters, Context<BukkitSource> ctx) {
        EntityCondition entityPredicted = (sender, entity) -> true;
        for (SelectionParameterInput<?> input : inputParameters) {
            if (!(input.getField() instanceof PredicateField)) continue;
            PredicateField predicateField = (PredicateField)input.getField();
            entityPredicted = entityPredicted.and((sender, entity) -> predicateField.isApplicable(sender, entity, input.getValue(), commandInputStream, ctx));
        }
        return entityPredicted;
    }

    private static <V> void operateFields(List<SelectionParameterInput<?>> inputParameters, List<Entity> selected) {
        for (SelectionParameterInput<?> input : inputParameters) {
            if (!(input.getField() instanceof OperatorField)) continue;
            OperatorField operatorField = (OperatorField)input.getField();
            operatorField.operate(input.getValue(), selected);
        }
    }

    public SuggestionResolver<BukkitSource> getSuggestionResolver() {
        return this.suggestionResolver;
    }

    private final class TargetSelectorSuggestionResolver
    implements SuggestionResolver<BukkitSource> {
        private TargetSelectorSuggestionResolver() {
        }

        public List<String> autoComplete(SuggestionContext<BukkitSource> context, CommandParameter<BukkitSource> parameter) {
            ArrayList<String> completions = new ArrayList<String>(ParameterTargetSelector.this.suggestions);
            Bukkit.getOnlinePlayers().stream().map(Player::getName).forEach(completions::add);
            return completions;
        }
    }
}

