/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.AnnotationReplacer;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.processors.CommandPostProcessor;
import studio.mevera.imperat.command.processors.CommandPreProcessor;
import studio.mevera.imperat.command.suggestions.AutoCompleter;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.ExecutionResult;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.exception.AmbiguousUsageAdditionException;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.InvalidSyntaxException;
import studio.mevera.imperat.exception.PermissionDeniedException;
import studio.mevera.imperat.exception.ProcessorException;
import studio.mevera.imperat.exception.UsageRegistrationException;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.Pair;
import studio.mevera.imperat.util.Preconditions;
import studio.mevera.imperat.util.TypeWrap;
import studio.mevera.imperat.verification.UsageVerifier;

public abstract class BaseImperat<S extends Source>
implements Imperat<S> {
    protected final ImperatConfig<S> config;
    @NotNull
    private AnnotationParser<S> annotationParser;
    private final Map<String, Command<S>> commands = new HashMap<String, Command<S>>();

    protected BaseImperat(@NotNull ImperatConfig<S> config) {
        this.config = config;
        this.annotationParser = AnnotationParser.defaultParser(this);
        config.applyAnnotationReplacers(this);
    }

    @Override
    @NotNull
    public ImperatConfig<S> config() {
        return this.config;
    }

    @Override
    public boolean canBeSender(Type type) {
        return TypeWrap.of(Source.class).isSupertypeOf(type);
    }

    @Override
    public void registerCommand(Command<S> command) {
        try {
            UsageVerifier<S> verifier = this.config.getUsageVerifier();
            for (CommandUsage<S> usage : command.usages()) {
                if (!verifier.verify(usage)) {
                    throw new UsageRegistrationException(command, usage);
                }
                for (CommandUsage<S> other : command.usages()) {
                    if (other.equals(usage) || !verifier.areAmbiguous(usage, other)) continue;
                    throw new AmbiguousUsageAdditionException(command, usage, other);
                }
            }
            this.registerCmd(command);
        }
        catch (RuntimeException ex) {
            ImperatDebugger.error(BaseImperat.class, "registerCommand(CommandProcessingChain command)", ex);
            this.shutdownPlatform();
        }
    }

    private void registerCmd(@NotNull Command<S> command) {
        command.tree().computePermissions();
        this.commands.put(command.name().trim().toLowerCase(), command);
        for (String aliases : command.aliases()) {
            this.commands.put(aliases.trim().toLowerCase(), command);
        }
    }

    @Override
    public void registerCommand(Class<?> commandClass) {
        Preconditions.notNull(commandClass, "commandClass");
        Object classInstance = this.config.getInstanceFactory().createInstance(this.config, commandClass);
        this.annotationParser.parseCommandClass(Objects.requireNonNull(classInstance));
    }

    @Override
    public void registerCommand(Object commandInstance) {
        if (commandInstance instanceof Command) {
            Command command = (Command)commandInstance;
            this.registerCommand((Object)command);
        } else if (commandInstance instanceof Class) {
            Class cls = (Class)commandInstance;
            this.registerCommand(cls);
        } else {
            this.annotationParser.parseCommandClass(Objects.requireNonNull(commandInstance));
        }
    }

    @Override
    public void unregisterCommand(String name) {
        Preconditions.notNull(name, "commandToRemove");
        Command<S> removed = this.commands.remove(name.trim().toLowerCase());
        if (removed != null) {
            for (String aliases : removed.aliases()) {
                this.commands.remove(aliases.trim().toLowerCase());
            }
        }
    }

    @Override
    public void unregisterAllCommands() {
        this.commands.clear();
    }

    @Override
    @Nullable
    public Command<S> getCommand(String name) {
        String cmdName = name.toLowerCase();
        Command<S> result = this.commands.get(cmdName);
        if (result != null) {
            return result;
        }
        for (Command<S> headCommands : this.commands.values()) {
            if (!headCommands.hasName(cmdName)) continue;
            return headCommands;
        }
        return null;
    }

    @Override
    public void setAnnotationParser(AnnotationParser<S> parser) {
        Preconditions.notNull(parser, "Parser");
        this.annotationParser = parser;
    }

    @Override
    @SafeVarargs
    public final void registerAnnotations(Class<? extends Annotation> ... type) {
        this.annotationParser.registerAnnotations(type);
    }

    @Override
    public <A extends Annotation> void registerAnnotationReplacer(Class<A> type, AnnotationReplacer<A> replacer) {
        this.annotationParser.registerAnnotationReplacer(type, replacer);
    }

    @Override
    @Nullable
    public Command<S> getSubCommand(String owningCommand, String name) {
        Command<S> owningCmd = this.getCommand(owningCommand);
        if (owningCmd == null) {
            return null;
        }
        for (Command<S> subCommand : owningCmd.getSubCommands()) {
            Command<S> result = this.search(subCommand, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Command<S> search(Command<S> sub, String name) {
        if (sub.hasName(name)) {
            return sub;
        }
        Iterator<Command<S>> iterator = sub.getSubCommands().iterator();
        if (iterator.hasNext()) {
            Command<S> other = iterator.next();
            if (other.hasName(name)) {
                return other;
            }
            return this.search(other, name);
        }
        return null;
    }

    private ExecutionResult<S> handleExecution(Context<S> context) throws ImperatException {
        Command<S> command = context.command();
        S source = context.source();
        if (!this.config.getPermissionChecker().hasPermission(source, command.getSinglePermission())) {
            throw new PermissionDeniedException(command.getDefaultUsage(), Objects.requireNonNull(command.getSinglePermission()), command, context);
        }
        CommandPathSearch<S> searchResult = command.contextMatch(context);
        ImperatDebugger.debug("Search-result: '" + searchResult.getResult().name() + "'", new Object[0]);
        if (searchResult.getResult() == CommandPathSearch.Result.PAUSE) {
            throw new PermissionDeniedException(searchResult, context);
        }
        CommandUsage<S> usage = searchResult.getFoundUsage();
        if (usage == null || searchResult.getLastNode() == null || searchResult.getResult() != CommandPathSearch.Result.COMPLETE) {
            ImperatDebugger.debug("Usage not found !", new Object[0]);
            throw new InvalidSyntaxException(searchResult, context);
        }
        Pair<String, Boolean> usageAccessCheckResult = this.config.getPermissionChecker().hasUsagePermission(source, usage);
        if (!usageAccessCheckResult.right().booleanValue()) {
            ImperatDebugger.debug("Failed usage permission check !", new Object[0]);
            throw new PermissionDeniedException(usage, usageAccessCheckResult.left(), null, context);
        }
        return this.executeUsage(command, source, context, usage, searchResult);
    }

    protected ExecutionResult<S> executeUsage(Command<S> command, S source, Context<S> context, CommandUsage<S> usage, CommandPathSearch<S> dispatch) throws ImperatException {
        this.globalPreProcessing(context, usage);
        command.preProcess(this, context, usage);
        ExecutionContext<S> resolvedContext = this.config.getContextFactory().createExecutionContext(context, dispatch);
        resolvedContext.resolve();
        usage.execute(this, source, resolvedContext);
        this.globalPostProcessing(resolvedContext);
        command.postProcess(this, resolvedContext, usage);
        return ExecutionResult.of(resolvedContext, dispatch, context);
    }

    private void globalPreProcessing(@NotNull Context<S> context, @NotNull CommandUsage<S> usage) throws ProcessorException {
        for (CommandPreProcessor preProcessor : this.config.getPreProcessors()) {
            try {
                preProcessor.process(this, context, usage);
            }
            catch (Throwable ex) {
                throw new ProcessorException(ProcessorException.Type.PRE, null, ex, context);
            }
        }
    }

    private void globalPostProcessing(@NotNull ExecutionContext<S> context) throws ImperatException {
        for (CommandPostProcessor postProcessor : this.config.getPostProcessors()) {
            try {
                postProcessor.process(this, context);
            }
            catch (Throwable ex) {
                throw new ProcessorException(ProcessorException.Type.POST, null, ex, context);
            }
        }
    }

    @Override
    @NotNull
    public ExecutionResult<S> execute(@NotNull Context<S> context) {
        try {
            context.command().visualizeTree();
            return this.handleExecution(context);
        }
        catch (Exception ex) {
            this.config().handleExecutionThrowable(ex, context, BaseImperat.class, "execute(Context<S> context)");
            return ExecutionResult.failure(ex, context);
        }
    }

    @Override
    @NotNull
    public ExecutionResult<S> execute(@NotNull S source, @NotNull Command<S> command, @NotNull String commandName, String[] rawInput) {
        ArgumentInput rawArguments = ArgumentInput.parse(rawInput);
        Context<S> plainContext = this.config.getContextFactory().createContext(this, source, command, commandName, rawArguments);
        return this.execute(plainContext);
    }

    @Override
    @NotNull
    public ExecutionResult<S> execute(@NotNull S source, @NotNull String commandName, String[] rawInput) {
        Command<S> command = this.getCommand(commandName);
        if (command == null) {
            throw new IllegalArgumentException("Unknown command input: '" + commandName + "'");
        }
        return this.execute(source, command, commandName, rawInput);
    }

    @Override
    @NotNull
    public ExecutionResult<S> execute(@NotNull S sender, @NotNull String commandName, @NotNull String rawArgsOneLine) {
        return this.execute(sender, commandName, rawArgsOneLine.split(" "));
    }

    @Override
    @NotNull
    public ExecutionResult<S> execute(@NotNull S sender, @NotNull String line) {
        if (line.isBlank()) {
            throw new IllegalArgumentException("Empty Command Line");
        }
        String[] lineArgs = line.split(" ");
        String[] argumentsOnly = new String[lineArgs.length - 1];
        System.arraycopy(lineArgs, 1, argumentsOnly, 0, lineArgs.length - 1);
        return this.execute(sender, lineArgs[0], argumentsOnly);
    }

    @Override
    public CompletableFuture<List<String>> autoComplete(@NotNull S source, @NotNull String fullCommandLine) {
        int firstSpace = fullCommandLine.indexOf(32);
        if (firstSpace == -1) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        String cmdName = fullCommandLine.substring(0, firstSpace);
        Command<S> command = this.getCommand(cmdName);
        if (command == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        ArgumentInput argumentInput = ArgumentInput.parseAutoCompletion(fullCommandLine.substring(firstSpace), false);
        SuggestionContext<S> context = this.config.getContextFactory().createSuggestionContext(this, source, command, cmdName, argumentInput);
        return command.autoCompleter().autoComplete(context).exceptionally(ex -> {
            this.config.handleExecutionThrowable(ex, context, AutoCompleter.class, "autoComplete(dispatcher, sender, args)");
            return Collections.emptyList();
        });
    }

    @Override
    public Collection<? extends Command<S>> getRegisteredCommands() {
        return this.commands.values();
    }

    @Override
    @NotNull
    public AnnotationParser<S> getAnnotationParser() {
        return this.annotationParser;
    }

    @Override
    public void debug(boolean treeVisualizing) {
        for (Command<S> cmd : this.commands.values()) {
            if (treeVisualizing) {
                cmd.visualizeTree();
                continue;
            }
            ImperatDebugger.debug("Debugging command '%s'", cmd.name());
            for (CommandUsage<S> usage : cmd.usages()) {
                ImperatDebugger.debug("   - '%s'", CommandUsage.format(cmd, usage));
            }
        }
    }
}

