/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.ThrowableHandler;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.SelfHandledException;
import studio.mevera.imperat.exception.ThrowableResolver;
import studio.mevera.imperat.util.ImperatDebugger;

public interface BaseThrowableHandler<S extends Source>
extends ThrowableHandler<S> {
    @Override
    default public <E extends Throwable> boolean handleExecutionThrowable(@NotNull E throwable, Context<S> context, Class<?> owning, String methodName) {
        for (Object current = throwable; current != null; current = ((Throwable)current).getCause()) {
            if (current instanceof SelfHandledException) {
                SelfHandledException selfHandledException = (SelfHandledException)current;
                selfHandledException.handle(context.imperatConfig(), context);
                return true;
            }
            ThrowableResolver<?, S> handler = this.getThrowableResolver(current.getClass());
            if (handler == null) continue;
            ImperatDebugger.debug("Found handler for exception '%s'", current.getClass().getName());
            handler.resolve(current, context);
            return true;
        }
        return false;
    }
}

