/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.ImperatConfigImpl;
import studio.mevera.imperat.NodePermissionAssigner;
import studio.mevera.imperat.PermissionLoader;
import studio.mevera.imperat.annotations.base.AnnotationReplacer;
import studio.mevera.imperat.annotations.base.InstanceFactory;
import studio.mevera.imperat.command.AttachmentMode;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.ContextResolverFactory;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.processors.CommandPostProcessor;
import studio.mevera.imperat.command.processors.CommandPreProcessor;
import studio.mevera.imperat.command.processors.CommandProcessingChain;
import studio.mevera.imperat.command.returns.ReturnResolver;
import studio.mevera.imperat.command.tree.help.HelpCoordinator;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.ContextFactory;
import studio.mevera.imperat.exception.ThrowableResolver;
import studio.mevera.imperat.placeholders.Placeholder;
import studio.mevera.imperat.resolvers.ContextResolver;
import studio.mevera.imperat.resolvers.DependencySupplier;
import studio.mevera.imperat.resolvers.PermissionChecker;
import studio.mevera.imperat.resolvers.SourceResolver;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.verification.UsageVerifier;

public abstract class ConfigBuilder<S extends Source, I extends Imperat<S>, B extends ConfigBuilder<S, I, B>> {
    protected final ImperatConfig<S> config = new ImperatConfigImpl();

    protected ConfigBuilder() {
    }

    public B commandPrefix(String cmdPrefix) {
        this.config.setCommandPrefix(cmdPrefix);
        return (B)this;
    }

    public B permissionChecker(PermissionChecker<S> permissionChecker) {
        this.config.setPermissionResolver(permissionChecker);
        return (B)this;
    }

    public B autoPermissionAssignMode(boolean modeToggle) {
        this.config.setAutoPermissionAssignMode(modeToggle);
        return (B)this;
    }

    @ApiStatus.Experimental
    public B permissionLoader(PermissionLoader<S> permissionLoader) {
        if (!this.config.isAutoPermissionAssignMode()) {
            throw new IllegalStateException("Please enable APA(Auto Permission Assign) Mode before doing this");
        }
        this.config.setPermissionLoader(permissionLoader);
        return (B)this;
    }

    @ApiStatus.Experimental
    public B permissionAssigner(NodePermissionAssigner<S> permissionAssigner) {
        if (!this.config.isAutoPermissionAssignMode()) {
            throw new IllegalStateException("Please enable APA(Auto Permission Assign) Mode before doing this");
        }
        this.config.setNodePermissionAssigner(permissionAssigner);
        return (B)this;
    }

    public B helpCoordinator(HelpCoordinator<S> coordinator) {
        this.config.setHelpCoordinator(coordinator);
        return (B)this;
    }

    public B contextFactory(ContextFactory<S> contextFactory) {
        this.config.setContextFactory(contextFactory);
        return (B)this;
    }

    public B usageVerifier(UsageVerifier<S> usageVerifier) {
        this.config.setUsageVerifier(usageVerifier);
        return (B)this;
    }

    public B returnResolver(Type type, ReturnResolver<S, ?> returnResolver) {
        if (!returnResolver.getType().equals(type)) {
            throw new IllegalArgumentException("The return resolver entered, has a to-return type that does not match the entered type.");
        }
        this.config.registerReturnResolver(type, returnResolver);
        return (B)this;
    }

    public B dependencyResolver(Type type, DependencySupplier resolver) {
        this.config.registerDependencyResolver(type, resolver);
        return (B)this;
    }

    public <A extends Annotation> B annotationReplacer(Class<A> annotationType, AnnotationReplacer<A> replacer) {
        this.config.registerAnnotationReplacer(annotationType, replacer);
        return (B)this;
    }

    public B overlapOptionalParameterSuggestions(boolean overlap) {
        this.config.setOptionalParameterSuggestionOverlap(overlap);
        return (B)this;
    }

    public B setDefaultSuggestionResolver(SuggestionResolver<S> resolver) {
        this.config.setDefaultSuggestionResolver(resolver);
        return (B)this;
    }

    public <T extends Throwable> B throwableResolver(Class<T> exception, ThrowableResolver<T, S> handler) {
        this.config.setThrowableResolver(exception, handler);
        return (B)this;
    }

    public B preProcessor(CommandPreProcessor<S> preProcessor) {
        this.config.getPreProcessors().add(preProcessor);
        return (B)this;
    }

    public B postProcessor(CommandPostProcessor<S> postProcessor) {
        this.config.getPostProcessors().add(postProcessor);
        return (B)this;
    }

    public B preProcessingChain(CommandProcessingChain<S, CommandPreProcessor<S>> chain) {
        this.config.setPreProcessorsChain(chain);
        return (B)this;
    }

    public B postProcessingChain(CommandProcessingChain<S, CommandPostProcessor<S>> chain) {
        this.config.setPostProcessorsChain(chain);
        return (B)this;
    }

    public <T> B contextResolverFactory(Type type, ContextResolverFactory<S, T> factory) {
        this.config.registerContextResolverFactory(type, factory);
        return (B)this;
    }

    public <T> B contextResolver(Type type, ContextResolver<S, T> resolver) {
        this.config.registerContextResolver(type, resolver);
        return (B)this;
    }

    public <T> B parameterType(Type type, ParameterType<S, T> resolver) {
        this.config.registerParamType(type, resolver);
        return (B)this;
    }

    public B applyOnConfig(@NotNull Consumer<ImperatConfig<S>> configConsumer) {
        configConsumer.accept(this.config);
        return (B)this;
    }

    public B namedSuggestionResolver(String name, SuggestionResolver<S> suggestionResolver) {
        this.config.registerNamedSuggestionResolver(name, suggestionResolver);
        return (B)this;
    }

    public B defaultSuggestionResolver(@NotNull SuggestionResolver<S> suggestionResolver) {
        this.config.setDefaultSuggestionResolver(suggestionResolver);
        return (B)this;
    }

    public <R> B sourceResolver(Type type, SourceResolver<S, R> sourceResolver) {
        this.config.registerSourceResolver(type, sourceResolver);
        return (B)this;
    }

    public B placeholder(Placeholder<S> placeholder) {
        this.config.registerPlaceholder(placeholder);
        return (B)this;
    }

    public B globalDefaultUsageBuilder(CommandUsage.Builder<S> usage) {
        this.config.setGlobalDefaultUsage(usage);
        return (B)this;
    }

    public B handleMiddleOptionalArgSkipping(boolean toggle) {
        this.config.setHandleExecutionConsecutiveOptionalArgumentsSkip(toggle);
        return (B)this;
    }

    public B defaultAttachmentMode(AttachmentMode attachmentMode) {
        this.config.setDefaultAttachmentMode(attachmentMode);
        return (B)this;
    }

    public B instanceFactory(InstanceFactory<S> instanceFactory) {
        this.config.setInstanceFactory(instanceFactory);
        return (B)this;
    }

    @NotNull
    public abstract I build();
}

