/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.NodePermissionAssigner;
import studio.mevera.imperat.PermissionLoader;
import studio.mevera.imperat.annotations.base.AnnotationReplacer;
import studio.mevera.imperat.annotations.base.InstanceFactory;
import studio.mevera.imperat.annotations.base.element.ParameterElement;
import studio.mevera.imperat.command.AttachmentMode;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.ContextResolverFactory;
import studio.mevera.imperat.command.ContextResolverRegistry;
import studio.mevera.imperat.command.ReturnResolverRegistry;
import studio.mevera.imperat.command.SourceResolverRegistry;
import studio.mevera.imperat.command.parameters.NumericRange;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.processors.CommandPostProcessor;
import studio.mevera.imperat.command.processors.CommandPreProcessor;
import studio.mevera.imperat.command.processors.CommandProcessingChain;
import studio.mevera.imperat.command.processors.impl.DefaultProcessors;
import studio.mevera.imperat.command.returns.ReturnResolver;
import studio.mevera.imperat.command.suggestions.SuggestionResolverRegistry;
import studio.mevera.imperat.command.tree.help.HelpCoordinator;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.ParamTypeRegistry;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.ContextFactory;
import studio.mevera.imperat.exception.CooldownException;
import studio.mevera.imperat.exception.InvalidSourceException;
import studio.mevera.imperat.exception.InvalidSyntaxException;
import studio.mevera.imperat.exception.InvalidUUIDException;
import studio.mevera.imperat.exception.MissingFlagInputException;
import studio.mevera.imperat.exception.NoHelpException;
import studio.mevera.imperat.exception.NoHelpPageException;
import studio.mevera.imperat.exception.NumberOutOfRangeException;
import studio.mevera.imperat.exception.PermissionDeniedException;
import studio.mevera.imperat.exception.SourceException;
import studio.mevera.imperat.exception.ThrowableResolver;
import studio.mevera.imperat.exception.UnknownFlagException;
import studio.mevera.imperat.exception.parse.InvalidBooleanException;
import studio.mevera.imperat.exception.parse.InvalidEnumException;
import studio.mevera.imperat.exception.parse.InvalidMapEntryFormatException;
import studio.mevera.imperat.exception.parse.InvalidNumberFormatException;
import studio.mevera.imperat.exception.parse.UnknownSubCommandException;
import studio.mevera.imperat.exception.parse.ValueOutOfConstraintException;
import studio.mevera.imperat.exception.parse.WordOutOfRestrictionsException;
import studio.mevera.imperat.placeholders.Placeholder;
import studio.mevera.imperat.placeholders.PlaceholderRegistry;
import studio.mevera.imperat.resolvers.ContextResolver;
import studio.mevera.imperat.resolvers.DependencySupplier;
import studio.mevera.imperat.resolvers.PermissionChecker;
import studio.mevera.imperat.resolvers.SourceResolver;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.Preconditions;
import studio.mevera.imperat.util.Registry;
import studio.mevera.imperat.util.TypeWrap;
import studio.mevera.imperat.verification.UsageVerifier;

final class ImperatConfigImpl<S extends Source>
implements ImperatConfig<S> {
    private InstanceFactory<S> instanceFactory = InstanceFactory.defaultFactory();
    @NotNull
    private SuggestionResolver<S> defaultSuggestionResolver = (context, input) -> Collections.emptyList();
    @NotNull
    private PermissionChecker<S> permissionChecker = (source, permission) -> true;
    @NotNull
    private ContextFactory<S> contextFactory;
    @NotNull
    private UsageVerifier<S> verifier;
    private final Registry<Type, DependencySupplier> dependencyResolverRegistry = new Registry();
    private final ContextResolverRegistry<S> contextResolverRegistry;
    private final ParamTypeRegistry<S> paramTypeRegistry;
    private final SuggestionResolverRegistry<S> suggestionResolverRegistry;
    private final PlaceholderRegistry<S> placeholderRegistry;
    private final SourceResolverRegistry<S> sourceResolverRegistry;
    private final ReturnResolverRegistry<S> returnResolverRegistry;
    private final Map<Class<? extends Throwable>, ThrowableResolver<?, S>> handlers = new HashMap();
    @NotNull
    private CommandProcessingChain<S, CommandPreProcessor<S>> globalPreProcessors;
    @NotNull
    private CommandProcessingChain<S, CommandPostProcessor<S>> globalPostProcessors;
    private boolean overlapOptionalParameterSuggestions = false;
    private boolean handleExecutionConsecutiveOptionalArgumentsSkip = false;
    private String commandPrefix = "/";
    private final Map<Class<?>, AnnotationReplacer<?>> annotationReplacerMap = new HashMap();
    private CommandUsage.Builder<S> globalDefaultUsage = CommandUsage.builder();
    private AttachmentMode defaultAttachmentMode = AttachmentMode.UNSET;
    private boolean isAPA;
    private PermissionLoader<S> permissionLoader = PermissionLoader.defaultLoader();
    private NodePermissionAssigner<S> permissionAssigner = NodePermissionAssigner.defaultAssigner();
    private HelpCoordinator<S> helpCoordinator = HelpCoordinator.create();

    ImperatConfigImpl() {
        this.contextResolverRegistry = ContextResolverRegistry.createDefault();
        this.paramTypeRegistry = ParamTypeRegistry.createDefault();
        this.suggestionResolverRegistry = SuggestionResolverRegistry.createDefault(this);
        this.sourceResolverRegistry = SourceResolverRegistry.createDefault();
        this.returnResolverRegistry = ReturnResolverRegistry.createDefault();
        this.placeholderRegistry = PlaceholderRegistry.createDefault(this);
        this.contextFactory = ContextFactory.defaultFactory();
        this.verifier = UsageVerifier.typeTolerantVerifier();
        this.regDefThrowableResolvers();
        this.globalPreProcessors = CommandProcessingChain.preProcessors().then(DefaultProcessors.preUsageCooldown()).build();
        this.globalPostProcessors = CommandProcessingChain.postProcessors().build();
    }

    private void regDefThrowableResolvers() {
        this.setThrowableResolver(InvalidSourceException.class, (exception, context) -> {
            throw new UnsupportedOperationException("Couldn't find any source resolver for valueType `" + exception.getTargetType().getTypeName() + "'");
        });
        this.setThrowableResolver(UnknownFlagException.class, (ex, context) -> context.source().error("Unknown flag '" + ex.getInput() + "'"));
        this.setThrowableResolver(MissingFlagInputException.class, (ex, context) -> context.source().error("Please enter the value for flag '" + ex.getInput() + "'"));
        this.setThrowableResolver(ValueOutOfConstraintException.class, (ex, context) -> context.source().error("Input '" + ex.getInput() + "' is not one of: [" + String.join((CharSequence)",", ex.getAllowedValues()) + "]"));
        this.setThrowableResolver(WordOutOfRestrictionsException.class, (ex, context) -> context.source().error("Word '" + ex.getInput() + "' is not within the given restrictions=" + String.join((CharSequence)",", ex.getRestrictions())));
        this.setThrowableResolver(UnknownSubCommandException.class, (exception, context) -> context.source().error("Unknown sub-command '" + exception.getInput() + "'"));
        this.setThrowableResolver(InvalidMapEntryFormatException.class, (exception, context) -> {
            InvalidMapEntryFormatException.Reason reason = exception.getReason();
            Object extraMsg = "";
            if (reason == InvalidMapEntryFormatException.Reason.MISSING_SEPARATOR) {
                extraMsg = "entry doesn't contain '" + exception.getRequiredSeparator() + "'";
            } else if (reason == InvalidMapEntryFormatException.Reason.NOT_TWO_ELEMENTS) {
                extraMsg = "entry is not made of 2 elements";
            }
            context.source().error("Invalid map entry '" + exception.getInput() + "'" + (String)(!((String)extraMsg).isEmpty() ? ", " + (String)extraMsg : ""));
        });
        this.setThrowableResolver(InvalidBooleanException.class, (exception, context) -> context.source().error("Invalid boolean '" + exception.getInput() + "'"));
        this.setThrowableResolver(InvalidEnumException.class, (exception, context) -> context.source().error("Invalid " + exception.getEnumType().getTypeName() + " '" + exception.getInput() + "'"));
        this.setThrowableResolver(InvalidNumberFormatException.class, (exception, context) -> context.source().error("Invalid " + exception.getNumberTypeDisplay() + " format '" + exception.getInput() + "'"));
        this.setThrowableResolver(NumberOutOfRangeException.class, (exception, context) -> {
            NumericRange range = exception.getRange();
            StringBuilder builder = new StringBuilder();
            if (range.getMin() != Double.MIN_VALUE && range.getMax() != Double.MAX_VALUE) {
                builder.append("within ").append(range.getMin()).append('-').append(range.getMax());
            } else if (range.getMin() != Double.MIN_VALUE) {
                builder.append("at least '").append(range.getMin()).append("'");
            } else if (range.getMax() != Double.MAX_VALUE) {
                builder.append("at most '").append(range.getMax()).append("'");
            } else {
                builder.append("(Open range)");
            }
            String rangeFormatted = builder.toString();
            context.source().error("Value '" + String.valueOf(exception.getValue()) + "' entered for parameter '" + exception.getParameter().format() + "' must be " + rangeFormatted);
        });
        this.setThrowableResolver(SourceException.class, (exception, context) -> {
            String msg = exception.getMessage();
            switch (exception.getType()) {
                case SEVERE: {
                    context.source().error(msg);
                    break;
                }
                case WARN: {
                    context.source().warn(msg);
                    break;
                }
                case REPLY: {
                    context.source().reply(msg);
                }
            }
        });
        this.setThrowableResolver(InvalidUUIDException.class, (exception, context) -> context.source().error("Invalid uuid-format '" + exception.getInput() + "'"));
        this.setThrowableResolver(CooldownException.class, (exception, context) -> context.source().error("Please wait %d second(s) to execute this command again!".formatted(exception.getRemainingDuration().toSeconds())));
        this.setThrowableResolver(PermissionDeniedException.class, (exception, context) -> context.source().error("You don't have permission to use this command!"));
        this.setThrowableResolver(InvalidSyntaxException.class, (exception, context) -> {
            Object source = context.source();
            source.error("Invalid command usage '/" + context.command().name() + " " + context.arguments().join(" ") + "'");
            CommandUsage<?> closestUsage = exception.getExecutionResult().getClosestUsage();
            if (closestUsage != null) {
                source.error("Closest Command Usage: " + context.imperatConfig().commandPrefix() + CommandUsage.format(context.label(), closestUsage));
            }
        });
        this.setThrowableResolver(NoHelpException.class, (exception, context) -> {
            Command cmdUsed;
            if (context instanceof ExecutionContext) {
                ExecutionContext resolvedContext = (ExecutionContext)context;
                cmdUsed = resolvedContext.getLastUsedCommand();
            } else {
                cmdUsed = context.command();
            }
            assert (cmdUsed != null);
            context.source().error("No Help available for '<command>'".replace("<command>", cmdUsed.name()));
        });
        this.setThrowableResolver(NoHelpPageException.class, (exception, context) -> {
            ExecutionContext resolvedContext;
            if (!(context instanceof ExecutionContext) || (resolvedContext = (ExecutionContext)context).getDetectedUsage() == null) {
                throw new IllegalCallerException("Called NoHelpPageCaption in wrong the wrong sequence/part of the code");
            }
            int page = resolvedContext.getArgumentOr("page", 1);
            context.source().error("Page '<page>' doesn't exist!".replace("<page>", String.valueOf(page)));
        });
    }

    @Override
    public String commandPrefix() {
        return this.commandPrefix;
    }

    @Override
    public void setCommandPrefix(String cmdPrefix) {
        this.commandPrefix = cmdPrefix;
    }

    @Override
    public void setPreProcessorsChain(CommandProcessingChain<S, CommandPreProcessor<S>> chain) {
        Preconditions.notNull(chain, "pre-processors chain");
        this.globalPreProcessors = chain;
    }

    @Override
    public void setPostProcessorsChain(CommandProcessingChain<S, CommandPostProcessor<S>> chain) {
        Preconditions.notNull(chain, "post-processors chain");
        this.globalPostProcessors = chain;
    }

    @Override
    public CommandProcessingChain<S, CommandPreProcessor<S>> getPreProcessors() {
        return this.globalPreProcessors;
    }

    @Override
    public CommandProcessingChain<S, CommandPostProcessor<S>> getPostProcessors() {
        return this.globalPostProcessors;
    }

    @Override
    @NotNull
    public PermissionChecker<S> getPermissionChecker() {
        return this.permissionChecker;
    }

    @Override
    public void setPermissionResolver(@NotNull PermissionChecker<S> permissionChecker) {
        this.permissionChecker = permissionChecker;
    }

    @Override
    @NotNull
    public ContextFactory<S> getContextFactory() {
        return this.contextFactory;
    }

    @Override
    public void setContextFactory(@NotNull ContextFactory<S> contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public boolean hasContextResolver(Type type) {
        return this.getContextResolver(type) != null;
    }

    @Override
    public <T> void registerContextResolverFactory(Type type, ContextResolverFactory<S, T> factory) {
        this.contextResolverRegistry.registerFactory(type, factory);
    }

    @Override
    @Nullable
    public <T> ContextResolverFactory<S, T> getContextResolverFactory(Type type) {
        return this.contextResolverRegistry.getFactoryFor(type).orElse(null);
    }

    @Override
    @Nullable
    public <T> ContextResolver<S, T> getContextResolver(Type resolvingContextType) {
        return this.contextResolverRegistry.getResolverWithoutParameterElement(resolvingContextType);
    }

    @Override
    @Nullable
    public <T> ContextResolver<S, T> getMethodParamContextResolver(@NotNull ParameterElement element) {
        Preconditions.notNull(element, "element");
        return this.contextResolverRegistry.getContextResolver(element.getType(), element);
    }

    @Override
    public <T> void registerContextResolver(Type type, @NotNull ContextResolver<S, T> resolver) {
        this.contextResolverRegistry.registerResolver(type, resolver);
    }

    @Override
    public <T> void registerParamType(Type type, @NotNull ParameterType<S, T> resolver) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(resolver, "resolver");
        this.paramTypeRegistry.registerResolver(type, () -> resolver);
        Class<?> rawType = TypeWrap.of(type).getRawType();
        this.paramTypeRegistry.registerArrayInitializer(rawType, length -> (Object[])Array.newInstance(rawType, (int)length));
    }

    @Override
    public <C extends Collection<?>> void registerCollectionInitializer(Class<C> collectionType, Supplier<C> newInstanceSupplier) {
        Preconditions.notNull(collectionType, "collectionType");
        Preconditions.notNull(newInstanceSupplier, "newInstanceSupplier");
        this.paramTypeRegistry.registerCollectionInitializer(collectionType, newInstanceSupplier);
    }

    @Override
    public <M extends Map<?, ?>> void registerMapInitializer(Class<M> mapType, Supplier<M> newInstanceSupplier) {
        Preconditions.notNull(mapType, "mapType");
        Preconditions.notNull(newInstanceSupplier, "newInstanceSupplier");
        this.paramTypeRegistry.registerMapInitializer(mapType, newInstanceSupplier);
    }

    @Override
    @NotNull
    public SuggestionResolver<S> getDefaultSuggestionResolver() {
        return this.defaultSuggestionResolver;
    }

    @Override
    public void setDefaultSuggestionResolver(@NotNull SuggestionResolver<S> defaultSuggestionResolver) {
        this.defaultSuggestionResolver = defaultSuggestionResolver;
    }

    @Override
    @Nullable
    public ParameterType<S, ?> getParameterType(Type resolvingValueType) {
        return this.paramTypeRegistry.getResolver(resolvingValueType).orElse(null);
    }

    @Override
    public <A extends Annotation> void registerAnnotationReplacer(Class<A> type, AnnotationReplacer<A> replacer) {
        this.annotationReplacerMap.put(type, replacer);
    }

    @Override
    public <A extends Annotation> void applyAnnotationReplacers(Imperat<S> imperat) {
        this.annotationReplacerMap.forEach((type, replacer) -> {
            Class annType = type;
            AnnotationReplacer annReplacer = replacer;
            imperat.registerAnnotationReplacer(annType, annReplacer);
        });
    }

    @Override
    public void setPermissionLoader(PermissionLoader<S> assigner) {
        this.permissionLoader = assigner;
    }

    @Override
    @NotNull
    public PermissionLoader<S> getPermissionLoader() {
        return this.permissionLoader;
    }

    @Override
    public void setNodePermissionAssigner(NodePermissionAssigner<S> assigner) {
        this.permissionAssigner = assigner;
    }

    @Override
    @NotNull
    public NodePermissionAssigner<S> getPermissionAssigner() {
        return this.permissionAssigner;
    }

    @Override
    public boolean isAutoPermissionAssignMode() {
        return this.isAPA;
    }

    @Override
    @ApiStatus.Experimental
    public void setAutoPermissionAssignMode(boolean toggle) {
        this.isAPA = toggle;
    }

    @Override
    public boolean isOptionalParameterSuggestionOverlappingEnabled() {
        return this.overlapOptionalParameterSuggestions;
    }

    @Override
    public void setOptionalParameterSuggestionOverlap(boolean enabled) {
        this.overlapOptionalParameterSuggestions = enabled;
    }

    @Override
    public boolean handleExecutionMiddleOptionalSkipping() {
        return this.handleExecutionConsecutiveOptionalArgumentsSkip;
    }

    @Override
    public void setHandleExecutionConsecutiveOptionalArgumentsSkip(boolean toggle) {
        this.handleExecutionConsecutiveOptionalArgumentsSkip = toggle;
    }

    @Override
    @Nullable
    public SuggestionResolver<S> getSuggestionResolverByType(Type type) {
        return this.paramTypeRegistry.getResolver(type).map(ParameterType::getSuggestionResolver).orElse(null);
    }

    @Override
    @Nullable
    public SuggestionResolver<S> getNamedSuggestionResolver(String name) {
        return this.suggestionResolverRegistry.getResolverByName(name);
    }

    @Override
    public void registerNamedSuggestionResolver(String name, SuggestionResolver<S> suggestionResolver) {
        this.suggestionResolverRegistry.registerNamedResolver(name.toLowerCase(), suggestionResolver);
    }

    @Override
    public void registerPlaceholder(Placeholder<S> placeholder) {
        this.placeholderRegistry.setData(placeholder.id(), placeholder);
    }

    @Override
    public Optional<Placeholder<S>> getPlaceHolder(String id) {
        return this.placeholderRegistry.getData(id);
    }

    @Override
    @NotNull
    public String replacePlaceholders(String input) {
        return this.placeholderRegistry.resolvedString(input);
    }

    @Override
    @NotNull
    public String[] replacePlaceholders(String[] array) {
        return this.placeholderRegistry.resolvedArray(array);
    }

    @Override
    @Nullable
    public <R> SourceResolver<S, R> getSourceResolver(Type type) {
        return this.sourceResolverRegistry.getData(type).orElse(null);
    }

    @Override
    public <R> void registerSourceResolver(Type type, SourceResolver<S, R> sourceResolver) {
        this.sourceResolverRegistry.setData(type, sourceResolver);
    }

    @Override
    @Nullable
    public <T> ReturnResolver<S, T> getReturnResolver(Type type) {
        return this.returnResolverRegistry.getReturnResolver(type);
    }

    @Override
    public <T> void registerReturnResolver(Type type, ReturnResolver<S, T> returnResolver) {
        this.returnResolverRegistry.setData(type, returnResolver);
    }

    @Override
    public void setUsageVerifier(UsageVerifier<S> usageVerifier) {
        this.verifier = usageVerifier;
    }

    @Override
    public void registerDependencyResolver(Type type, DependencySupplier resolver) {
        this.dependencyResolverRegistry.setData(type, resolver);
    }

    @Override
    @Nullable
    public <T> T resolveDependency(Type type) {
        return this.dependencyResolverRegistry.getData(type).map(Supplier::get).orElse(null);
    }

    @Override
    public UsageVerifier<S> getUsageVerifier() {
        return this.verifier;
    }

    @Override
    @Nullable
    public <T extends Throwable> ThrowableResolver<T, S> getThrowableResolver(Class<T> exception) {
        for (Class<T> current = exception; current != null && Throwable.class.isAssignableFrom(current); current = current.getSuperclass()) {
            ThrowableResolver<?, S> resolver = this.handlers.get(current);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }

    @Override
    public <T extends Throwable> void setThrowableResolver(Class<T> exception, ThrowableResolver<T, S> handler) {
        this.handlers.put(exception, handler);
    }

    @Override
    public @NotNull CommandUsage.Builder<S> getGlobalDefaultUsage() {
        return this.globalDefaultUsage;
    }

    @Override
    public void setGlobalDefaultUsage(@NotNull CommandUsage.Builder<S> globalDefaultUsage) {
        this.globalDefaultUsage = globalDefaultUsage;
    }

    @Override
    @NotNull
    public AttachmentMode getDefaultAttachmentMode() {
        return this.defaultAttachmentMode;
    }

    @Override
    public void setDefaultAttachmentMode(AttachmentMode attachmentMode) {
        this.defaultAttachmentMode = attachmentMode;
    }

    @Override
    @NotNull
    public HelpCoordinator<S> getHelpCoordinator() {
        return this.helpCoordinator;
    }

    @Override
    public void setHelpCoordinator(@NotNull HelpCoordinator<S> coordinator) {
        this.helpCoordinator = coordinator;
    }

    @Override
    public InstanceFactory<S> getInstanceFactory() {
        return this.instanceFactory;
    }

    @Override
    public void setInstanceFactory(InstanceFactory<S> factory) {
        this.instanceFactory = factory;
    }

    @Override
    public <E extends Throwable> boolean handleExecutionThrowable(@NotNull E throwable, Context<S> context, Class<?> owning, String methodName) {
        Command<S> cmd;
        if (context instanceof ExecutionContext) {
            ExecutionContext executionContext = (ExecutionContext)context;
            v0 = executionContext.getLastUsedCommand();
        } else {
            v0 = cmd = context.command();
        }
        while (cmd != null) {
            boolean res = cmd.handleExecutionThrowable(throwable, context, owning, methodName);
            if (res) {
                return true;
            }
            cmd = cmd.parent();
        }
        boolean res = ImperatConfig.super.handleExecutionThrowable(throwable, context, owning, methodName);
        if (!res) {
            ImperatDebugger.error(owning, methodName, throwable);
        }
        return true;
    }
}

