/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.ContextResolverFactory;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.returns.ReturnResolver;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.placeholders.Placeholder;
import studio.mevera.imperat.resolvers.ContextResolver;
import studio.mevera.imperat.resolvers.SourceResolver;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.TypeWrap;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ResolverRegistrar<S extends Source> {
    public <T> void registerContextResolverFactory(Type var1, ContextResolverFactory<S, T> var2);

    public <T> void registerContextResolver(Type var1, @NotNull ContextResolver<S, T> var2);

    public <T> void registerParamType(Type var1, @NotNull ParameterType<S, T> var2);

    public <C extends Collection<?>> void registerCollectionInitializer(Class<C> var1, Supplier<C> var2);

    public <M extends Map<?, ?>> void registerMapInitializer(Class<M> var1, Supplier<M> var2);

    public SuggestionResolver<S> getDefaultSuggestionResolver();

    public void setDefaultSuggestionResolver(SuggestionResolver<S> var1);

    @NotNull
    default public SuggestionResolver<S> getParameterSuggestionResolver(CommandParameter<S> parameter) {
        SuggestionResolver<S> parameterSpecificResolver = parameter.getSuggestionResolver();
        if (parameterSpecificResolver == null) {
            SuggestionResolver<S> resolverByType = parameter.type().getSuggestionResolver();
            return Objects.requireNonNullElseGet(resolverByType, this::getDefaultSuggestionResolver);
        }
        return parameterSpecificResolver;
    }

    @Nullable
    public SuggestionResolver<S> getSuggestionResolverByType(Type var1);

    @Nullable
    public SuggestionResolver<S> getNamedSuggestionResolver(String var1);

    public void registerNamedSuggestionResolver(String var1, SuggestionResolver<S> var2);

    @Nullable
    public <R> SourceResolver<S, R> getSourceResolver(Type var1);

    default public <R> void registerSourceResolver(TypeWrap<R> type, SourceResolver<S, R> sourceResolver) {
        this.registerSourceResolver(type.getType(), sourceResolver);
    }

    public <R> void registerSourceResolver(Type var1, SourceResolver<S, R> var2);

    @Nullable
    public <T> ReturnResolver<S, T> getReturnResolver(Type var1);

    default public <T> void registerReturnResolver(TypeWrap<T> type, ReturnResolver<S, T> returnResolver) {
        this.registerReturnResolver(type.getType(), returnResolver);
    }

    public <T> void registerReturnResolver(Type var1, ReturnResolver<S, T> var2);

    public void registerPlaceholder(Placeholder<S> var1);
}

