/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.FlagBuilder;
import studio.mevera.imperat.command.parameters.ParameterBuilder;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.TypeWrap;

public final class TextSyntaxParser<S extends Source> {
    private static final Pattern LITERAL_PATTERN = Pattern.compile("^[a-zA-Z0-9_]+$");
    private static final Pattern TRUE_FLAG_PATTERN = Pattern.compile("^--?[a-zA-Z0-9_]+(\\s+<[^>]+>)?$");
    private static final Pattern SWITCH_ONLY_PATTERN = Pattern.compile("^--?[a-zA-Z0-9_]+$");
    private final Imperat<S> imperat;

    private TextSyntaxParser(Imperat<S> imperat) {
        this.imperat = imperat;
    }

    public static <S extends Source> TextSyntaxParser<S> of(Imperat<S> imperat) {
        return new TextSyntaxParser<S>(imperat);
    }

    public CommandUsage<S> parseSyntaxToUsage(String syntax) {
        String[] parts;
        String trimmedSyntax = syntax.trim();
        String cmdPrefix = this.imperat.config().commandPrefix();
        if (trimmedSyntax.startsWith(this.imperat.config().commandPrefix())) {
            trimmedSyntax = trimmedSyntax.substring(cmdPrefix.length());
        }
        if ((parts = trimmedSyntax.split(" ")).length == 0) {
            throw new IllegalArgumentException("Invalid command syntax: " + syntax);
        }
        boolean registerNewCommand = false;
        Command command = this.imperat.getCommand(parts[0]);
        if (command == null) {
            command = Command.create(this.imperat, parts[0]).build();
            registerNewCommand = true;
        }
        CommandUsage.Builder commandUsage = CommandUsage.builder();
        ArrayList parameters = new ArrayList();
        for (int i = 1; i < parts.length; ++i) {
            ParameterBuilder parameter;
            String paramType;
            String part = parts[i];
            String[] partArr = part.split(":");
            String paramNameFormat = partArr[0];
            String string = paramType = partArr.length > 1 ? partArr[1] : "String";
            if (this.isLiteral(paramNameFormat)) {
                parameter = ParameterBuilder.literalBuilder(paramNameFormat);
                parameters.add(parameter);
                continue;
            }
            if (this.isTrueFlag(paramNameFormat)) {
                String id = this.extractFlagName(paramNameFormat);
                parameter = FlagBuilder.ofFlag(id, this.deduceParamTypeFromString(paramType));
                parameters.add(parameter);
                continue;
            }
            if (this.isSwitchOnlyFlag(paramNameFormat)) {
                String id = this.extractFlagName(paramNameFormat);
                parameter = FlagBuilder.ofSwitch(id);
                parameters.add(parameter);
                continue;
            }
            boolean optional = paramNameFormat.startsWith("[") && paramNameFormat.endsWith("]");
            String paramName = this.extractArgName(paramNameFormat);
            parameter = optional ? CommandParameter.optional(paramName, this.deduceParamTypeFromString(paramType)) : CommandParameter.required(paramName, this.deduceParamTypeFromString(paramType));
            parameters.add(parameter);
        }
        CommandUsage usage = commandUsage.parameterBuilders(parameters).build(command);
        command.addUsage(usage);
        if (registerNewCommand) {
            this.imperat.registerCommand(command);
        }
        return usage;
    }

    public Command<S> parseShortcutSyntax(Command<S> shortcutOwner, String syntax) {
        String[] parts;
        String trimmedSyntax = syntax.trim();
        String cmdPrefix = this.imperat.config().commandPrefix();
        if (trimmedSyntax.startsWith(this.imperat.config().commandPrefix())) {
            trimmedSyntax = trimmedSyntax.substring(cmdPrefix.length());
        }
        if ((parts = trimmedSyntax.split(" ")).length == 0) {
            throw new IllegalArgumentException("Invalid command syntax: " + syntax);
        }
        String root = parts[0];
        if (!this.isLiteral(root)) {
            throw new IllegalArgumentException("The root command must be a literal (alphanumeric and underscores only): " + root);
        }
        Command rootCommand = Command.create(this.imperat, root).setMetaPropertiesFromOtherCommand(shortcutOwner).build();
        CommandUsage.Builder commandUsage = CommandUsage.builder().setPropertiesFromCommandMainUsage(shortcutOwner);
        HashMap<String, CommandParameter<S>> params = new HashMap<String, CommandParameter<S>>();
        for (CommandUsage<S> usage : shortcutOwner.usages()) {
            for (CommandParameter<S> param : usage.getParameters()) {
                if (params.containsKey(param.format())) {
                    CommandParameter existing = (CommandParameter)params.get(param.format());
                    if (existing.position() == param.position()) continue;
                    throw new IllegalArgumentException("Duplicate parameter state with different positions[" + existing.position() + ", " + param.position() + "] : " + param.format() + " in command " + shortcutOwner.name());
                }
                params.put(param.format(), param);
            }
        }
        ArrayList orderedParameters = new ArrayList();
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            CommandParameter parameter = (CommandParameter)params.get(part);
            if (parameter == null) {
                if (this.isLiteral(part)) {
                    parameter = CommandParameter.literal(part);
                } else {
                    throw new IllegalArgumentException("No parameter found for part: " + part);
                }
            }
            orderedParameters.add(parameter.copyWithDifferentPosition(i));
        }
        commandUsage.parameters(orderedParameters);
        rootCommand.addUsage(commandUsage);
        return rootCommand;
    }

    private boolean isLiteral(String part) {
        return LITERAL_PATTERN.matcher(part).matches();
    }

    private boolean isTrueFlag(String part) {
        return TRUE_FLAG_PATTERN.matcher(part).matches();
    }

    private boolean isSwitchOnlyFlag(String part) {
        return SWITCH_ONLY_PATTERN.matcher(part).matches();
    }

    private String extractFlagName(String part) {
        String name = this.extractArgName(part);
        String[] split = name.split(" ");
        if (split.length > 0) {
            name = split[0];
        }
        if (name.startsWith("--")) {
            return name.substring(2);
        }
        if (name.startsWith("-")) {
            return name.substring(1);
        }
        return name;
    }

    private String extractArgName(String part) {
        return part.substring(1, part.length() - 1);
    }

    private ParameterType<S, ?> deduceParamTypeFromString(String typeName) {
        ParameterType<S, ?> customType;
        ImperatConfig<S> cfg = this.imperat.config();
        if (typeName.isBlank()) {
            return cfg.getParameterType((Type)((Object)String.class));
        }
        if (typeName.endsWith("[]")) {
            String elementTypeName = typeName.substring(0, typeName.length() - 2).trim();
            ParameterType<S, ?> elementType = this.deduceParamTypeFromString(elementTypeName);
            if (elementType == null) {
                throw new IllegalArgumentException("No parameter type registered for array element-type: " + elementTypeName);
            }
            TypeWrap<?> arrayType = TypeWrap.ofArray(elementType.type());
            return cfg.getParameterType(arrayType.getType());
        }
        if (typeName.equalsIgnoreCase("int") || typeName.equalsIgnoreCase("integer")) {
            return cfg.getParameterType((Type)((Object)Integer.class));
        }
        if (typeName.equalsIgnoreCase("long")) {
            return cfg.getParameterType((Type)((Object)Long.class));
        }
        if (typeName.equalsIgnoreCase("double")) {
            return cfg.getParameterType((Type)((Object)Double.class));
        }
        if (typeName.equalsIgnoreCase("float")) {
            return cfg.getParameterType((Type)((Object)Float.class));
        }
        if (typeName.equalsIgnoreCase("boolean") || typeName.equalsIgnoreCase("bool")) {
            return cfg.getParameterType((Type)((Object)Boolean.class));
        }
        if (typeName.equalsIgnoreCase("string") || typeName.equalsIgnoreCase("str")) {
            return cfg.getParameterType((Type)((Object)String.class));
        }
        if (this.isGenericType(typeName)) {
            String rawType = this.extractRawTypeName(typeName);
            try {
                Class<?> rawClass = Class.forName(rawType);
                ParameterType<S, ?> rawParamType = cfg.getParameterType(rawClass);
                if (rawParamType == null) {
                    throw new IllegalArgumentException("No parameter type registered for raw-type: " + rawType);
                }
                String[] genericTypesNames = this.extractGenericTypesNames(typeName);
                ParameterType[] genericParamTypes = new ParameterType[genericTypesNames.length];
                for (int i = 0; i < genericTypesNames.length; ++i) {
                    String genericTypeName = genericTypesNames[i];
                    ParameterType<S, ?> genericParamType = this.deduceParamTypeFromString(genericTypeName.trim());
                    if (genericParamType == null) {
                        throw new IllegalArgumentException("No parameter type registered for generic-type: " + genericTypeName);
                    }
                    genericParamTypes[i] = genericParamType;
                }
                TypeWrap<?> wrappedType = TypeWrap.ofParameterized(rawClass, List.of(genericParamTypes));
                return cfg.getParameterType(wrappedType.getType());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            customType = cfg.getParameterType(Class.forName(typeName));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unknown type from syntax: '" + typeName + "'", e);
        }
        return customType;
    }

    private String[] extractGenericTypesNames(String typeName) {
        int genericStart = typeName.indexOf("<");
        int genericEnd = typeName.lastIndexOf(">");
        if (genericStart == -1 || genericEnd == -1 || genericEnd <= genericStart) {
            throw new IllegalArgumentException("Invalid generic type format: " + typeName);
        }
        String genericLine = typeName.substring(genericStart + 1, genericEnd).trim();
        if (genericLine.contains(",")) {
            return genericLine.split(",");
        }
        return new String[]{genericLine};
    }

    private String extractRawTypeName(String typeName) {
        int genericStart = typeName.indexOf("<");
        if (genericStart == -1) {
            return typeName;
        }
        return typeName.substring(0, genericStart);
    }

    private boolean isGenericType(String typeName) {
        return typeName.contains("<") && typeName.endsWith(">");
    }
}

