/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.annotations.Default;
import studio.mevera.imperat.annotations.DefaultProvider;
import studio.mevera.imperat.annotations.Flag;
import studio.mevera.imperat.annotations.Named;
import studio.mevera.imperat.annotations.Switch;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.ParameterElement;
import studio.mevera.imperat.annotations.base.element.ParseElement;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.resolvers.ContextResolver;

public final class AnnotationHelper {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <S extends Source> Object[] loadParameterInstances(Imperat<S> dispatcher, List<CommandParameter<S>> fullParameters, S source, ExecutionContext<S> context, MethodElement method) throws ImperatException {
        Object[] paramsInstances = new Object[method.getParameters().size()];
        ParameterElement firstParam = method.getParameterAt(0);
        assert (firstParam != null);
        paramsInstances[0] = dispatcher.canBeSender(firstParam.getType()) ? (source.getClass().equals(firstParam.getType()) ? source : context.getResolvedSource(firstParam.getType())) : context.getResolvedSource(firstParam.getType());
        int i = 1;
        int p = 0;
        while (i < method.size()) {
            ParameterElement actualParameter = method.getParameterAt(i);
            assert (actualParameter != null);
            if (actualParameter.isContextResolved()) {
                ContextResolver contextResolver = dispatcher.config().getMethodParamContextResolver(actualParameter);
                if (contextResolver == null) throw new IllegalStateException("In class '%s', In method '%s', The parameter '%s' is set to be context resolved while not having a context resolver for its type '%s'".formatted(method.getParent().getName(), method.getName(), actualParameter.getName(), actualParameter.getType().getTypeName()));
                paramsInstances[i] = contextResolver.resolve(context, actualParameter);
                --p;
            } else {
                CommandParameter<S> parameter = AnnotationHelper.getUsageParam(fullParameters, p);
                if (parameter == null) {
                    if (actualParameter.isAnnotationPresent(Flag.class)) {
                        Flag flag = actualParameter.getAnnotation(Flag.class);
                        assert (flag != null);
                        if (!flag.free()) throw new IllegalArgumentException();
                        paramsInstances[i] = context.getFlagValue(flag.value()[0]);
                    }
                    --p;
                } else {
                    String name = parameter.name();
                    if (parameter.isFlag()) {
                        Object flagValue = context.getFlagValue(name);
                        paramsInstances[i] = flagValue == null && parameter.asFlagParameter().isSwitch() ? Boolean.valueOf(false) : flagValue;
                    } else {
                        Object ctxArg = context.getArgument(name);
                        paramsInstances[i] = ctxArg;
                    }
                }
            }
            ++i;
            ++p;
        }
        return paramsInstances;
    }

    @Nullable
    private static <S extends Source> CommandParameter<S> getUsageParam(List<? extends CommandParameter<S>> params, int index) {
        if (index < 0 || index >= params.size()) {
            return null;
        }
        return params.get(index);
    }

    @NotNull
    public static <S extends Source> String getParamName(ImperatConfig<S> imperat, ParameterElement parameter, @Nullable Named named, @Nullable Flag flag, @Nullable Switch switchAnnotation) {
        String name = named != null ? named.value() : (flag != null ? flag.value()[0] : (switchAnnotation != null ? switchAnnotation.value()[0] : ((Parameter)parameter.getElement()).getName()));
        return imperat.replacePlaceholders(name);
    }

    @NotNull
    public static <S extends Source> String getParamName(ImperatConfig<S> imperat, ParameterElement parameter) {
        return AnnotationHelper.getParamName(imperat, parameter, parameter.getAnnotation(Named.class), parameter.getAnnotation(Flag.class), parameter.getAnnotation(Switch.class));
    }

    @NotNull
    public static OptionalValueSupplier getOptionalValueSupplier(Class<? extends OptionalValueSupplier> supplierClass) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends OptionalValueSupplier> emptyConstructor = supplierClass.getDeclaredConstructor(new Class[0]);
        emptyConstructor.setAccessible(true);
        return emptyConstructor.newInstance(new Object[0]);
    }

    @NotNull
    public static OptionalValueSupplier deduceOptionalValueSupplier(ParameterElement parameter, Default defaultAnnotation, DefaultProvider provider, OptionalValueSupplier fallback) throws ImperatException {
        if (defaultAnnotation != null) {
            String def = defaultAnnotation.value();
            return OptionalValueSupplier.of(def);
        }
        if (provider != null) {
            Class<? extends OptionalValueSupplier> supplierClass = provider.value();
            try {
                return AnnotationHelper.getOptionalValueSupplier(supplierClass);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalAccessError("Optional value suppler class '" + supplierClass.getName() + "' doesn't have an empty accessible constructor !");
            }
        }
        return fallback;
    }

    public static boolean isAbnormalClass(ParseElement<?> parseElement) {
        if (parseElement instanceof ClassElement) {
            ClassElement classElement = (ClassElement)parseElement;
            return AnnotationHelper.isAbnormalClass((Class)classElement.getElement());
        }
        return false;
    }

    public static boolean isAbnormalClass(Class<?> element) {
        return element.isInterface() || element.isEnum() || Modifier.isAbstract(element.getModifiers());
    }
}

