/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base;

import java.lang.annotation.Annotation;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.AnnotationReader;
import studio.mevera.imperat.annotations.base.AnnotationRegistry;
import studio.mevera.imperat.annotations.base.AnnotationReplacer;
import studio.mevera.imperat.annotations.base.element.CommandClassVisitor;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.MethodThrowableResolver;
import studio.mevera.imperat.annotations.base.element.selector.ElementSelector;
import studio.mevera.imperat.annotations.base.element.selector.MethodRules;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.context.Source;

@ApiStatus.Internal
final class AnnotationParserImpl<S extends Source>
extends AnnotationParser<S> {
    final AnnotationRegistry annotationRegistry = new AnnotationRegistry();
    private final ElementSelector<MethodElement> methodSelector = ElementSelector.create();
    private final CommandClassVisitor<S, Set<Command<S>>> commandParsingVisitor;
    private final CommandClassVisitor<S, Set<MethodThrowableResolver<?, S>>> throwableHandlerVisitor;

    AnnotationParserImpl(Imperat<S> dispatcher) {
        super(dispatcher);
        this.methodSelector.addRule(MethodRules.IS_PUBLIC.and(MethodRules.HAS_A_MAIN_ANNOTATION));
        this.commandParsingVisitor = CommandClassVisitor.newCommandParsingVisitor(dispatcher, this);
        this.throwableHandlerVisitor = CommandClassVisitor.newThrowableParsingVisitor(dispatcher, this);
    }

    @Override
    public <T> void parseCommandClass(T instance) {
        AnnotationReader<S> reader = AnnotationReader.read(this.imperat, this.methodSelector, this, instance);
        reader.acceptCommandsParsing(this.commandParsingVisitor);
    }

    @Override
    public <T> void parseThrowableHandlerClass(T instance) {
        AnnotationReader<S> reader = AnnotationReader.read(this.imperat, CommandClassVisitor.ERROR_HANDLING_METHOD_SELECTOR, this, instance);
        reader.acceptThrowableResolversParsing(this.throwableHandlerVisitor);
    }

    @Override
    @SafeVarargs
    public final void registerAnnotations(Class<? extends Annotation> ... type) {
        this.annotationRegistry.registerAnnotationTypes(type);
    }

    @Override
    public <A extends Annotation> void registerAnnotationReplacer(Class<A> type, AnnotationReplacer<A> replacer) {
        this.annotationRegistry.registerAnnotationReplacer(type, replacer);
    }

    @Override
    public boolean isKnownAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotationRegistry.isRegisteredAnnotation(annotationType);
    }

    @Override
    public boolean hasAnnotationReplacerFor(Class<? extends Annotation> type) {
        return this.annotationRegistry.hasReplacerFor(type);
    }

    @Override
    @Nullable
    public <A extends Annotation> AnnotationReplacer<A> getAnnotationReplacer(Class<A> type) {
        return this.annotationRegistry.getAnnotationReplacer(type);
    }

    @Override
    AnnotationRegistry getAnnotationRegistry() {
        return this.annotationRegistry;
    }
}

