/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.annotations.ExternalSubCommand;
import studio.mevera.imperat.annotations.base.AnnotationHelper;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.AnnotationReader;
import studio.mevera.imperat.annotations.base.SourceOrderHelper;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.CommandClassVisitor;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.MethodThrowableResolver;
import studio.mevera.imperat.annotations.base.element.RootCommandClass;
import studio.mevera.imperat.annotations.base.element.selector.ElementSelector;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.ImperatDebugger;

@ApiStatus.Internal
final class AnnotationReaderImpl<S extends Source>
implements AnnotationReader<S> {
    private final Imperat<S> imperat;
    private final AnnotationParser<S> parser;
    private final ElementSelector<MethodElement> methodSelector;
    private final RootCommandClass<S> rootCommandClass;
    private final ClassElement classElement;

    AnnotationReaderImpl(Imperat<S> imperat, ElementSelector<MethodElement> methodSelector, AnnotationParser<S> parser, Object instance) {
        if (AnnotationHelper.isAbnormalClass(instance.getClass())) {
            throw new IllegalArgumentException("Failed to parse the abnormal class '%s'".formatted(instance.getClass().getTypeName()));
        }
        this.imperat = imperat;
        this.parser = parser;
        this.rootCommandClass = new RootCommandClass(instance.getClass(), instance);
        this.methodSelector = methodSelector;
        this.classElement = this.read(imperat);
    }

    @NotNull
    private ClassElement read(Imperat<S> imperat) {
        return this.readClass(imperat, this.parser, null, this.rootCommandClass.proxyClass());
    }

    @NotNull
    private ClassElement readClass(Imperat<S> imperat, AnnotationParser<S> parser, @Nullable ClassElement parent, @NotNull Class<?> clazz) {
        List<Class<?>> innerClasses;
        List<Method> methods;
        ClassElement root = parent == null ? new ClassElement(parser, null, clazz, this.rootCommandClass.proxyInstance()) : new ClassElement(parser, parent, clazz);
        try {
            methods = SourceOrderHelper.getMethodsInSourceOrder(clazz);
        }
        catch (Exception e) {
            ImperatDebugger.error(AnnotationReaderImpl.class, "readClass", e);
            throw new RuntimeException(e);
        }
        for (Method method : methods) {
            MethodElement methodElement = new MethodElement(parser, root, method);
            if (!this.methodSelector.canBeSelected(imperat, parser, methodElement, false)) continue;
            root.addChild(methodElement);
        }
        if (root.isAnnotationPresent(ExternalSubCommand.class)) {
            ExternalSubCommand externalSubCommand = root.getAnnotation(ExternalSubCommand.class);
            assert (externalSubCommand != null);
            for (Class<?> subClass : externalSubCommand.value()) {
                ImperatDebugger.debug("Found %s's external sub command class '%s'", ((Class)root.getElement()).getTypeName(), subClass.getTypeName());
                root.addChild(this.readClass(imperat, parser, root, subClass));
            }
        }
        try {
            innerClasses = SourceOrderHelper.getInnerClassesInSourceOrder(clazz);
        }
        catch (Exception exception) {
            ImperatDebugger.error(AnnotationReaderImpl.class, "readClass", exception);
            throw new RuntimeException(exception);
        }
        for (Class<?> child : innerClasses) {
            if (AnnotationHelper.isAbnormalClass(child)) {
                ImperatDebugger.debug("Ignoring abnormal sub class '%s'", child.getTypeName());
                continue;
            }
            root.addChild(this.readClass(imperat, parser, root, child));
        }
        return root;
    }

    @Override
    public RootCommandClass<S> getRootClass() {
        return this.rootCommandClass;
    }

    @Override
    public ClassElement getParsedClass() {
        return this.classElement;
    }

    @Override
    public void acceptCommandsParsing(CommandClassVisitor<S, Set<Command<S>>> visitor) {
        Set<Command<S>> collectedCommands = this.classElement.accept(visitor);
        if (collectedCommands == null) {
            return;
        }
        for (Command<S> loaded : collectedCommands) {
            this.imperat.registerCommand(loaded);
        }
    }

    @Override
    public <E extends Throwable> void acceptThrowableResolversParsing(CommandClassVisitor<S, Set<MethodThrowableResolver<?, S>>> visitor) {
        Set<MethodThrowableResolver<?, S>> collectedErrorHandlers = this.classElement.accept(visitor);
        if (collectedErrorHandlers == null) {
            return;
        }
        for (MethodThrowableResolver<?, S> errorHandler : collectedErrorHandlers) {
            Class<?> castedExceptionType = errorHandler.getExceptionType();
            this.imperat.config().setThrowableResolver(castedExceptionType, errorHandler);
        }
    }
}

