/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.annotations.base.InstanceFactory;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.UnknownDependencyException;

final class DefaultInstanceFactory<S extends Source>
implements InstanceFactory<S> {
    DefaultInstanceFactory() {
    }

    @Override
    @NotNull
    public <T> T createInstance(ImperatConfig<S> config, Class<T> cls) throws UnknownDependencyException {
        Object dependencyResolved = config.resolveDependency(cls);
        if (dependencyResolved != null) {
            return dependencyResolved;
        }
        try {
            return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnknownDependencyException("Failed to create instance of " + cls.getName(), e);
        }
    }
}

