/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base;

import java.lang.reflect.Method;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.annotations.base.AnnotationHelper;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.command.CommandExecution;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.returns.ReturnResolver;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.asm.DefaultMethodCallerFactory;
import studio.mevera.imperat.util.asm.MethodCaller;

@ApiStatus.Internal
public class MethodCommandExecutor<S extends Source>
implements CommandExecution<S> {
    private final Imperat<S> dispatcher;
    private final MethodElement method;
    private final MethodCaller.BoundMethodCaller boundMethodCaller;
    private final List<CommandParameter<S>> fullParameters;

    private MethodCommandExecutor(Imperat<S> dispatcher, MethodElement method, List<CommandParameter<S>> fullParameters) {
        try {
            this.dispatcher = dispatcher;
            this.method = method;
            ClassElement methodOwner = (ClassElement)method.getParent();
            this.boundMethodCaller = DefaultMethodCallerFactory.INSTANCE.createFor((Method)method.getElement()).bindTo(methodOwner.getObjectInstance());
            this.fullParameters = fullParameters;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <S extends Source> MethodCommandExecutor<S> of(Imperat<S> imperat, MethodElement method, List<CommandParameter<S>> fullParameters) {
        return new MethodCommandExecutor<S>(imperat, method, fullParameters);
    }

    @Override
    public void execute(S source, ExecutionContext<S> context) throws ImperatException {
        Object[] instances = AnnotationHelper.loadParameterInstances(this.dispatcher, this.fullParameters, source, context, this.method);
        Object returned = this.boundMethodCaller.call(instances);
        if (this.method.getReturnType() == Void.TYPE) {
            return;
        }
        ReturnResolver<S, Object> returnResolver = context.imperatConfig().getReturnResolver(this.method.getReturnType());
        if (returnResolver == null) {
            return;
        }
        returnResolver.handle(context, this.method, returned);
    }
}

