/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public final class SourceOrderHelper {
    private SourceOrderHelper() {
        throw new AssertionError();
    }

    @NotNull
    private static ClassLoader getClassLoader(Class<?> clazz) {
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return loader;
    }

    public static List<Method> getMethodsInSourceOrder(Class<?> clazz) throws Exception {
        String className = clazz.getName().replace('.', '/') + ".class";
        ClassLoader loader = SourceOrderHelper.getClassLoader(clazz);
        try (InputStream stream = loader.getResourceAsStream(className);){
            if (stream == null) {
                throw new IOException("Class resource not found: " + className);
            }
            ClassReader reader = new ClassReader(stream);
            MethodOrderVisitor visitor = new MethodOrderVisitor();
            reader.accept((ClassVisitor)visitor, 2);
            HashMap<CallSite, Method> methodMap = new HashMap<CallSite, Method>();
            for (Method method : clazz.getDeclaredMethods()) {
                String key = method.getName() + Type.getMethodDescriptor((Method)method);
                methodMap.put((CallSite)((Object)key), method);
            }
            ArrayList<Method> orderedMethods = new ArrayList<Method>();
            for (MethodSignature signature : visitor.getMethodSignatures()) {
                Method method;
                method = (Method)methodMap.get(signature.name + signature.descriptor);
                if (method == null || method.isSynthetic()) continue;
                orderedMethods.add(method);
            }
            ArrayList<Method> arrayList = orderedMethods;
            return arrayList;
        }
    }

    public static List<Class<?>> getInnerClassesInSourceOrder(Class<?> outerClass) throws Exception {
        String className = outerClass.getName().replace('.', '/') + ".class";
        try (InputStream stream = SourceOrderHelper.getClassLoader(outerClass).getResourceAsStream(className);){
            if (stream == null) {
                throw new IOException("Class resource not found: " + className);
            }
            ClassReader reader = new ClassReader(stream);
            InnerClassOrderVisitor visitor = new InnerClassOrderVisitor(outerClass.getName());
            reader.accept((ClassVisitor)visitor, 2);
            List<String> innerClassNames = visitor.getInnerClassNames();
            HashMap<String, Class> classMap = new HashMap<String, Class>();
            HashSet allInnerClasses = new HashSet(Arrays.asList(outerClass.getDeclaredClasses()));
            for (Class<?> nestMember : outerClass.getDeclaredClasses()) {
                if (nestMember.equals(outerClass)) continue;
                allInnerClasses.add(nestMember);
            }
            for (Class clazz : allInnerClasses) {
                classMap.put(clazz.getName(), clazz);
            }
            ArrayList orderedClasses = new ArrayList();
            for (String innerClassName : innerClassNames) {
                Class innerClass = (Class)classMap.get(innerClassName);
                if (innerClass == null) continue;
                orderedClasses.add(innerClass);
            }
            ArrayList arrayList = orderedClasses;
            return arrayList;
        }
    }

    private static class MethodOrderVisitor
    extends ClassVisitor {
        private final List<MethodSignature> methodSignatures = new ArrayList<MethodSignature>();

        public MethodOrderVisitor() {
            super(589824);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            this.methodSignatures.add(new MethodSignature(name, descriptor));
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }

        public List<MethodSignature> getMethodSignatures() {
            return this.methodSignatures;
        }
    }

    private static class MethodSignature {
        final String name;
        final String descriptor;

        MethodSignature(String name, String descriptor) {
            this.name = name;
            this.descriptor = descriptor;
        }
    }

    private static class InnerClassOrderVisitor
    extends ClassVisitor {
        private final List<String> innerClassNames = new ArrayList<String>();
        private final String outerClassName;

        public InnerClassOrderVisitor(String outerClassName) {
            super(589824);
            this.outerClassName = outerClassName;
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            String fullClassName = name.replace('/', '.');
            String expectedOuterName = this.outerClassName.replace('.', '/');
            if (outerName != null && outerName.equals(expectedOuterName)) {
                this.innerClassNames.add(0, fullClassName);
            }
            super.visitInnerClass(name, outerName, innerName, access);
        }

        public List<String> getInnerClassNames() {
            return this.innerClassNames;
        }
    }
}

