/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.annotations.Dependency;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.InstanceFactory;
import studio.mevera.imperat.annotations.base.element.CommandClassVisitor;
import studio.mevera.imperat.annotations.base.element.ParseElement;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.UnknownDependencyException;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.reflection.Reflections;

public final class ClassElement
extends ParseElement<Class<?>> {
    private final Set<ParseElement<?>> children = new LinkedHashSet();
    private final Object instance;

    public <S extends Source> ClassElement(@NotNull AnnotationParser<S> parser, @NotNull ClassElement parent, @NotNull Class<?> element) {
        super(parser, parent, element);
        this.instance = this.newInstance(parser.getImperat().config(), parent, new Object[0]);
        this.injectDependencies();
    }

    public <S extends Source> ClassElement(@NotNull AnnotationParser<S> parser, @Nullable ClassElement parent, @NotNull Class<?> element, @NotNull Object instance) {
        super(parser, parent, element);
        this.instance = instance;
        this.injectDependencies();
    }

    private <S extends Source> void injectDependencies() {
        IllegalAccessException exception = null;
        for (Field field : ((Class)this.element).getDeclaredFields()) {
            if (!field.isAnnotationPresent(Dependency.class)) continue;
            if (Modifier.isFinal(field.getModifiers())) {
                throw new IllegalArgumentException("Field '" + field.getName() + "' cannot be declared final while being annotated with `@Dependency`");
            }
            field.setAccessible(true);
            try {
                ImperatConfig config = this.parser.getImperat().config();
                InstanceFactory instanceFactory = config.getInstanceFactory();
                Object supplied = instanceFactory.createInstance(config, field.getType());
                field.set(Objects.requireNonNull(this.instance), supplied);
            }
            catch (IllegalAccessException e) {
                exception = e;
                break;
            }
        }
        if (exception != null) {
            throw new RuntimeException(exception);
        }
    }

    private <S extends Source> Object newInstance(ImperatConfig<S> config, ClassElement parent, Object ... constructorArgs) {
        InstanceFactory<S> factory = config.getInstanceFactory();
        try {
            return factory.createInstance(config, (Class)this.element);
        }
        catch (UnknownDependencyException e) {
            return this.loadInstanceFromConstructor(parent, constructorArgs);
        }
    }

    @NotNull
    private Object loadInstanceFromConstructor(ClassElement parent, Object[] constructorArgs) {
        boolean isStaticClass = this.isStaticClass();
        boolean external = !((Class)this.element).isMemberClass();
        try {
            Object[] finalArgs;
            Constructor<?> cons;
            if (isStaticClass || external) {
                Class[] types = new Class[constructorArgs.length];
                for (int i = 0; i < types.length; ++i) {
                    types[i] = constructorArgs[i].getClass();
                }
                cons = Reflections.getConstructor((Class)this.element, types);
                finalArgs = constructorArgs;
            } else {
                if (parent == null) {
                    throw new IllegalArgumentException("Non-static inner class " + ((Class)this.element).getSimpleName() + " requires a parent instance, but parent is null");
                }
                Object parentInstance = parent.getObjectInstance();
                if (parentInstance == null) {
                    throw new IllegalArgumentException("Parent instance is null for non-static inner class " + ((Class)this.element).getSimpleName());
                }
                Class[] types = new Class[constructorArgs.length + 1];
                types[0] = (Class)parent.getElement();
                for (int i = 0; i < constructorArgs.length; ++i) {
                    types[i + 1] = constructorArgs[i].getClass();
                }
                cons = Reflections.getConstructor((Class)this.element, types);
                finalArgs = new Object[constructorArgs.length + 1];
                finalArgs[0] = parentInstance;
                System.arraycopy(constructorArgs, 0, finalArgs, 1, constructorArgs.length);
            }
            if (cons == null) {
                throw new UnknownDependencyException("Class " + ((Class)this.element).getSimpleName() + " doesn't have a constructor matching the arguments");
            }
            return cons.newInstance(finalArgs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new UnknownDependencyException("Failed to create instance of " + ((Class)this.element).getSimpleName(), e);
        }
    }

    public boolean isStaticClass() {
        return Modifier.isStatic(((Class)this.element).getModifiers());
    }

    public Object getObjectInstance() {
        return this.instance;
    }

    public <S extends Source, R> R accept(CommandClassVisitor<S, R> visitor) {
        try {
            return visitor.visitCommandClass(this);
        }
        catch (Throwable ex) {
            ImperatDebugger.error(ClassElement.class, "ClassElement#accept", ex);
            return null;
        }
    }

    @Nullable
    public ParseElement<?> getChildElement(Predicate<ParseElement<?>> predicate) {
        for (ParseElement<?> element : this.getChildren()) {
            if (!predicate.test(element)) continue;
            return element;
        }
        return null;
    }

    public void addChild(ParseElement<?> element) {
        this.children.add(element);
        if (element instanceof ClassElement) {
            ImperatDebugger.debug("Class '" + ((Class)this.element).getTypeName() + "' has children: [" + String.join((CharSequence)",", this.children.stream().filter(pe -> pe instanceof ClassElement).map(ParseElement::getName).collect(Collectors.toUnmodifiableSet())) + "]", new Object[0]);
        }
    }

    public boolean isRootClass() {
        return this.getParent() == null;
    }

    @Override
    public String getName() {
        return ((Class)this.getElement()).getName();
    }

    public String getSimpleName() {
        return ((Class)this.getElement()).getSimpleName();
    }

    public Set<ParseElement<?>> getChildren() {
        return this.children;
    }
}

