/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element;

import java.util.Set;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.CommandParsingVisitor;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.MethodThrowableResolver;
import studio.mevera.imperat.annotations.base.element.ThrowableParsingVisitor;
import studio.mevera.imperat.annotations.base.element.selector.ElementSelector;
import studio.mevera.imperat.annotations.base.element.selector.MethodRules;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.context.Source;

public abstract class CommandClassVisitor<S extends Source, R> {
    public static final ElementSelector<MethodElement> ERROR_HANDLING_METHOD_SELECTOR = ElementSelector.create().addRule(MethodRules.HAS_EXCEPTION_HANDLER_ANNOTATION).addRule(MethodRules.HAS_EXCEPTION_HANDLER_PARAMS_IN_ORDER);
    protected final Imperat<S> imperat;
    protected final AnnotationParser<S> parser;
    protected final ElementSelector<MethodElement> methodSelector;

    protected CommandClassVisitor(Imperat<S> imperat, AnnotationParser<S> parser, ElementSelector<MethodElement> methodSelector) {
        this.imperat = imperat;
        this.parser = parser;
        this.methodSelector = methodSelector;
    }

    public abstract R visitCommandClass(@NotNull ClassElement var1);

    public static <S extends Source> CommandClassVisitor<S, Set<Command<S>>> newCommandParsingVisitor(Imperat<S> imperat, AnnotationParser<S> parser) {
        return new CommandParsingVisitor<S>(imperat, parser, ElementSelector.create().addRule(MethodRules.HAS_KNOWN_SENDER));
    }

    public static <S extends Source> CommandClassVisitor<S, Set<MethodThrowableResolver<?, S>>> newThrowableParsingVisitor(Imperat<S> imperat, AnnotationParser<S> parser) {
        return new ThrowableParsingVisitor<S>(imperat, parser, ERROR_HANDLING_METHOD_SELECTOR);
    }
}

