/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.annotations.Async;
import studio.mevera.imperat.annotations.Command;
import studio.mevera.imperat.annotations.Cooldown;
import studio.mevera.imperat.annotations.Default;
import studio.mevera.imperat.annotations.DefaultProvider;
import studio.mevera.imperat.annotations.Description;
import studio.mevera.imperat.annotations.Flag;
import studio.mevera.imperat.annotations.Format;
import studio.mevera.imperat.annotations.GlobalAttachmentMode;
import studio.mevera.imperat.annotations.Greedy;
import studio.mevera.imperat.annotations.Permission;
import studio.mevera.imperat.annotations.PostProcessor;
import studio.mevera.imperat.annotations.PreProcessor;
import studio.mevera.imperat.annotations.Range;
import studio.mevera.imperat.annotations.SubCommand;
import studio.mevera.imperat.annotations.Suggest;
import studio.mevera.imperat.annotations.SuggestionProvider;
import studio.mevera.imperat.annotations.Switch;
import studio.mevera.imperat.annotations.Usage;
import studio.mevera.imperat.annotations.Values;
import studio.mevera.imperat.annotations.base.AnnotationHelper;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.MethodCommandExecutor;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.CommandClassVisitor;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.MethodThrowableResolver;
import studio.mevera.imperat.annotations.base.element.ParameterElement;
import studio.mevera.imperat.annotations.base.element.ParseElement;
import studio.mevera.imperat.annotations.base.element.selector.ElementSelector;
import studio.mevera.imperat.annotations.parameters.AnnotationParameterDecorator;
import studio.mevera.imperat.annotations.parameters.NumericParameterDecorator;
import studio.mevera.imperat.command.AttachmentMode;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandCoordinator;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.ConstrainedParameterTypeDecorator;
import studio.mevera.imperat.command.parameters.InputParameter;
import studio.mevera.imperat.command.parameters.NumericRange;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.StrictParameterList;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.processors.CommandPostProcessor;
import studio.mevera.imperat.command.processors.CommandPreProcessor;
import studio.mevera.imperat.command.processors.CommandProcessor;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeWrap;

@ApiStatus.Internal
final class CommandParsingVisitor<S extends Source>
extends CommandClassVisitor<S, Set<studio.mevera.imperat.command.Command<S>>> {
    private final ImperatConfig<S> config;
    private static final String VALUES_SEPARATION_CHAR = "\\|";
    private final CommandClassVisitor<S, Set<MethodThrowableResolver<?, S>>> errorHandlersVisitor;

    CommandParsingVisitor(Imperat<S> imperat, AnnotationParser<S> parser, ElementSelector<MethodElement> methodSelector) {
        super(imperat, parser, methodSelector);
        this.config = imperat.config();
        this.errorHandlersVisitor = CommandClassVisitor.newThrowableParsingVisitor(imperat, parser);
    }

    @Override
    public Set<studio.mevera.imperat.command.Command<S>> visitCommandClass(@NotNull ClassElement clazz) {
        HashSet<studio.mevera.imperat.command.Command<S>> commands = new HashSet<studio.mevera.imperat.command.Command<S>>();
        Annotation commandAnnotation = this.getCommandAnnotation(clazz);
        if (clazz.isRootClass() && commandAnnotation != null && clazz.isAnnotationPresent(SubCommand.class)) {
            throw new IllegalStateException("Root command class cannot be a @SubCommand");
        }
        if (commandAnnotation != null) {
            if (clazz.isRootClass() && AnnotationHelper.isAbnormalClass(clazz)) {
                throw new IllegalArgumentException("Abnormal root class '%s'".formatted(clazz.getName()));
            }
            studio.mevera.imperat.command.Command<S> cmd = this.loadCommand(null, clazz, commandAnnotation);
            if (cmd != null) {
                this.loadCommandMethods(clazz);
                commands.add(cmd);
            }
        } else {
            for (ParseElement<?> element : clazz.getChildren()) {
                studio.mevera.imperat.command.Command<S> cmd;
                if (!element.isAnnotationPresent(Command.class) || (cmd = this.loadCommand(null, element, Objects.requireNonNull(element.getAnnotation(Command.class)))) == null) continue;
                this.imperat.registerCommand(cmd);
            }
        }
        return commands;
    }

    private Annotation getCommandAnnotation(ClassElement clazz) {
        if (clazz.isAnnotationPresent(Command.class)) {
            return clazz.getAnnotation(Command.class);
        }
        if (clazz.isAnnotationPresent(SubCommand.class)) {
            return clazz.getAnnotation(SubCommand.class);
        }
        return null;
    }

    private void loadCommandMethods(ClassElement clazz) {
        for (ParseElement<?> element : clazz.getChildren()) {
            MethodElement method;
            if (!(element instanceof MethodElement) || !(method = (MethodElement)element).isAnnotationPresent(Command.class)) continue;
            Command cmdAnn = method.getAnnotation(Command.class);
            assert (cmdAnn != null);
            this.imperat.registerCommand(this.loadCommand(null, method, cmdAnn));
        }
    }

    private <E extends Throwable> studio.mevera.imperat.command.Command<S> loadCmdInstance(Annotation cmdAnnotation, ParseElement<?> element) {
        ClassElement classElement;
        Set<MethodThrowableResolver<?, S>> errorHandlersCollected;
        Command.Builder<S> builder;
        PreProcessor preProcessor = element.getAnnotation(PreProcessor.class);
        PostProcessor postProcessor = element.getAnnotation(PostProcessor.class);
        Permission permission = element.getAnnotation(Permission.class);
        Description description = element.getAnnotation(Description.class);
        if (cmdAnnotation instanceof Command) {
            Command cmdAnn = (Command)cmdAnnotation;
            values = this.config.replacePlaceholders(cmdAnn.value());
            aliases = List.of(values).subList(1, values.length);
            ignoreAC = cmdAnn.skipSuggestionsChecks();
            builder = studio.mevera.imperat.command.Command.create(this.imperat, values[0]).ignoreACPermissions(ignoreAC).aliases(aliases);
            if (permission != null) {
                builder.permission(this.config.replacePlaceholders(permission.value()));
            }
            if (description != null) {
                builder.description(this.config.replacePlaceholders(description.value()));
            }
            if (preProcessor != null) {
                for (Class<CommandProcessor<?>> clazz : preProcessor.value()) {
                    builder.preProcessor(this.loadPreProcessorInstance(clazz));
                }
            }
            if (postProcessor != null) {
                for (Class<CommandProcessor<?>> clazz : postProcessor.value()) {
                    builder.postProcessor(this.loadPostProcessorInstance(clazz));
                }
            }
        } else if (cmdAnnotation instanceof SubCommand) {
            SubCommand subCommand = (SubCommand)cmdAnnotation;
            values = this.config.replacePlaceholders(subCommand.value());
            assert (values != null);
            aliases = List.of(values).subList(1, values.length);
            ignoreAC = subCommand.skipSuggestionsChecks();
            builder = studio.mevera.imperat.command.Command.create(this.imperat, values[0]).ignoreACPermissions(ignoreAC).aliases(aliases);
            if (permission != null) {
                builder.permission(this.config.replacePlaceholders(permission.value()));
            }
            if (description != null) {
                builder.description(this.config.replacePlaceholders(description.value()));
            }
            if (preProcessor != null) {
                for (Class<CommandProcessor<?>> clazz : preProcessor.value()) {
                    builder.preProcessor(this.loadPreProcessorInstance(clazz));
                }
            }
            if (postProcessor != null) {
                for (Class<CommandProcessor<?>> clazz : postProcessor.value()) {
                    builder.postProcessor(this.loadPostProcessorInstance(clazz));
                }
            }
        } else {
            return null;
        }
        studio.mevera.imperat.command.Command<S> cmd = builder.build();
        if (element instanceof ClassElement && (errorHandlersCollected = this.errorHandlersVisitor.visitCommandClass(classElement = (ClassElement)element)) != null) {
            for (MethodThrowableResolver<?, S> errorHandler : errorHandlersCollected) {
                cmd.setThrowableResolver(errorHandler.getExceptionType(), errorHandler);
            }
        }
        return cmd;
    }

    @Nullable
    private studio.mevera.imperat.command.Command<S> loadCommand(@Nullable studio.mevera.imperat.command.Command<S> parentCmd, ParseElement<?> parseElement, @NotNull Annotation annotation) {
        if (AnnotationHelper.isAbnormalClass(parseElement)) {
            return null;
        }
        studio.mevera.imperat.command.Command<S> cmd = this.loadCmdInstance(annotation, parseElement);
        if (parentCmd != null && cmd != null) {
            cmd.parent(parentCmd);
        }
        if (parseElement instanceof MethodElement) {
            MethodElement method = (MethodElement)parseElement;
            if (cmd != null) {
                if (!this.methodSelector.canBeSelected(this.imperat, this.parser, method, true)) {
                    ImperatDebugger.debugForTesting("Method '%s' has failed verification", method.getName());
                    return cmd;
                }
                CommandUsage<S> usage = this.loadUsage(parentCmd, cmd, method);
                if (usage != null) {
                    cmd.addUsage(usage);
                }
                return cmd;
            }
        }
        if (parseElement instanceof ClassElement) {
            ClassElement commandClass = (ClassElement)parseElement;
            for (ParseElement<?> element : commandClass.getChildren()) {
                if (element instanceof MethodElement) {
                    CommandUsage<S> usage;
                    MethodElement method = (MethodElement)element;
                    if (cmd == null) {
                        throw new IllegalStateException("Method  '" + ((Method)method.getElement()).getName() + "' Cannot be treated as usage/subcommand, it doesn't have a parent ");
                    }
                    if (!this.methodSelector.canBeSelected(this.imperat, this.parser, method, true)) {
                        return cmd;
                    }
                    if (method.isAnnotationPresent(SubCommand.class)) {
                        SubCommand subAnn = method.getAnnotation(SubCommand.class);
                        assert (subAnn != null);
                        cmd.addSubCommand(this.loadCommand(cmd, method, subAnn), this.extractAttachmentMode(commandClass, subAnn));
                    }
                    if (!method.isAnnotationPresent(Usage.class) || (usage = this.loadUsage(parentCmd, cmd, method)) == null) continue;
                    cmd.addUsage(usage);
                    continue;
                }
                if (!(element instanceof ClassElement)) continue;
                ClassElement innerClass = (ClassElement)element;
                if (innerClass.isAnnotationPresent(Command.class)) {
                    Command innerCmdAnn = innerClass.getAnnotation(Command.class);
                    assert (innerCmdAnn != null);
                    this.imperat.registerCommand(this.loadCommand(null, innerClass, innerCmdAnn));
                    return null;
                }
                if (!innerClass.isAnnotationPresent(SubCommand.class)) continue;
                if (cmd == null) {
                    throw new IllegalStateException("Inner class '" + ((Class)innerClass.getElement()).getSimpleName() + "' Cannot be  treated as subcommand, it doesn't have a parent ");
                }
                SubCommand subCommandAnn = innerClass.getAnnotation(SubCommand.class);
                assert (subCommandAnn != null);
                cmd.addSubCommand(this.loadCommand(cmd, innerClass, subCommandAnn), this.extractAttachmentMode(commandClass, subCommandAnn));
            }
        }
        return cmd;
    }

    private AttachmentMode extractAttachmentMode(ClassElement commandClass, SubCommand subCommandAnn) {
        AttachmentMode attachmentMode = this.config.getDefaultAttachmentMode() == AttachmentMode.UNSET ? subCommandAnn.attachment() : this.config.getDefaultAttachmentMode();
        GlobalAttachmentMode globalAttachmentMode = commandClass.getAnnotation(GlobalAttachmentMode.class);
        if (globalAttachmentMode != null && attachmentMode == AttachmentMode.UNSET) {
            attachmentMode = globalAttachmentMode.value();
        }
        return attachmentMode;
    }

    private CommandPreProcessor<S> loadPreProcessorInstance(Class<? extends CommandPreProcessor<?>> clazz) {
        return this.config.getInstanceFactory().createInstance(this.config, clazz);
    }

    private CommandPostProcessor<S> loadPostProcessorInstance(Class<? extends CommandPostProcessor<?>> clazz) {
        return this.config.getInstanceFactory().createInstance(this.config, clazz);
    }

    private CommandUsage<S> loadUsage(@Nullable studio.mevera.imperat.command.Command<S> parentCmd, @NotNull studio.mevera.imperat.command.Command<S> loadedCmd, MethodElement method) {
        MethodUsageData<S> usageData = this.loadParameters(method, parentCmd);
        MethodCommandExecutor<S> execution = MethodCommandExecutor.of(this.imperat, method, usageData.inheritedTotalParameters());
        Description description = method.getAnnotation(Description.class);
        Permission permission = method.getAnnotation(Permission.class);
        Cooldown cooldown = method.getAnnotation(Cooldown.class);
        Async async = method.getAnnotation(Async.class);
        CommandUsage.Builder builder = CommandUsage.builder().parameters(usageData.personalParameters()).execute(execution);
        Usage usageAnn = method.getAnnotation(Usage.class);
        if (usageAnn != null) {
            String[] examples = (String[])Arrays.stream(usageAnn.examples()).map(this.config::replacePlaceholders).toArray(String[]::new);
            builder.examples(examples);
        }
        if (description != null) {
            builder.description(this.config.replacePlaceholders(description.value()));
        }
        if (permission != null) {
            builder.permission(this.config.replacePlaceholders(permission.value()));
        }
        if (cooldown != null) {
            ImperatDebugger.debug("Method '%s' has cooldown", method.getName());
            String cooldownPerm = cooldown.permission();
            builder.cooldown(cooldown.value(), cooldown.unit(), cooldownPerm.isEmpty() ? null : cooldownPerm);
        }
        if (async != null) {
            builder.coordinator(CommandCoordinator.async());
        }
        boolean help = method.isHelp();
        return builder.registerFlags(usageData.freeFlags).build(loadedCmd, help);
    }

    private MethodUsageData<S> loadParameters(@NotNull MethodElement method, @Nullable studio.mevera.imperat.command.Command<S> parentCmd) {
        ParameterElement parameterElement;
        ImperatDebugger.debugForTesting("Loading for method '%s'", method.getName());
        LinkedList personalMethodInputParameters = new LinkedList();
        StrictParameterList mainUsageParameters = new StrictParameterList();
        boolean doesRequireParameterInheritance = CommandParsingVisitor.doesRequireParameterInheritance(parentCmd, method);
        ImperatDebugger.debug("Method '%s' Requires inheritance= " + doesRequireParameterInheritance, method.getName());
        if (CommandParsingVisitor.doesRequireParameterInheritance(parentCmd, method)) {
            LinkedList<studio.mevera.imperat.command.Command<S>> parenteralSequence = CommandParsingVisitor.getParenteralSequence(parentCmd);
            for (studio.mevera.imperat.command.Command command : parenteralSequence) {
                command.getMainUsage().getParameters().forEach(param -> {
                    if (!param.isFlag() || !param.asFlagParameter().flagData().isFree()) {
                        mainUsageParameters.add(param);
                    }
                });
            }
        }
        StringBuilder inheritedParamsFormatted = CommandParsingVisitor.getMainUsageParametersCollected(mainUsageParameters);
        ImperatDebugger.debugForTesting("Main usage params collected '%s'", inheritedParamsFormatted.toString());
        LinkedList totalMethodParameters = new LinkedList(mainUsageParameters);
        LinkedList<ParameterElement> linkedList = new LinkedList<ParameterElement>(method.getParameters());
        ImperatDebugger.debugForTesting("Method parameters collected '%s'", this.getMethodParamsCollected(linkedList));
        HashSet freeFlags = new HashSet();
        ParameterElement senderParam = null;
        if (doesRequireParameterInheritance && linkedList.size() - 1 == 0 && !mainUsageParameters.isEmpty() && parentCmd != null) {
            throw new IllegalStateException("You have inherited parameters ('%s') that are not declared in the method '%s' in class '%s'".formatted(inheritedParamsFormatted, method.getName(), method.getParent().getName()));
        }
        while (!linkedList.isEmpty() && (parameterElement = linkedList.peek()) != null) {
            if (senderParam == null && this.isSenderParameter(parameterElement)) {
                senderParam = linkedList.remove();
                continue;
            }
            CommandParameter<S> commandParameter = this.loadParameter(parameterElement);
            if (commandParameter == null) {
                linkedList.remove();
                continue;
            }
            if (commandParameter.isFlag() && commandParameter.asFlagParameter().flagData().isFree()) {
                freeFlags.add(commandParameter.asFlagParameter().flagData());
                linkedList.remove();
                continue;
            }
            CommandParameter mainParameter = (CommandParameter)mainUsageParameters.peek();
            if (mainParameter != null) {
                ImperatDebugger.debugForTesting("Comparing main-usage parameter '%s' with loaded parameter '%s'", mainParameter.format(), commandParameter.format());
            }
            if (mainParameter == null) {
                ImperatDebugger.debugForTesting("Adding command parameter '%s' that has no corresponding main parameter", commandParameter.format());
                personalMethodInputParameters.add(commandParameter);
                totalMethodParameters.add(commandParameter);
                linkedList.remove();
                continue;
            }
            if (mainParameter.similarTo(commandParameter)) {
                ImperatDebugger.debugForTesting("Main parameter '%s' is exactly similar to loaded parameter '%s'", mainParameter.format(), commandParameter.format());
                ParameterElement methodParam = linkedList.remove();
                ImperatDebugger.debugForTesting("Removing '%s' from method params", methodParam.getName());
                CommandParameter mainUsageParam = (CommandParameter)mainUsageParameters.remove();
                ImperatDebugger.debugForTesting("Removing '%s' from main usage params", mainUsageParam.format());
                continue;
            }
            personalMethodInputParameters.add(commandParameter);
            totalMethodParameters.add(commandParameter);
            mainUsageParameters.remove();
            linkedList.remove();
        }
        return new MethodUsageData(personalMethodInputParameters, totalMethodParameters, freeFlags);
    }

    private static <S extends Source> boolean doesRequireParameterInheritance(@Nullable studio.mevera.imperat.command.Command<S> parentCmd, @NotNull MethodElement method) {
        boolean requiresParameterInheritance = false;
        if (method.isAnnotationPresent(SubCommand.class)) {
            AttachmentMode attachment = Objects.requireNonNull(method.getAnnotation(SubCommand.class)).attachment();
            requiresParameterInheritance = parentCmd == null ? attachment.requiresParameterInheritance() : (attachment == AttachmentMode.DEFAULT ? parentCmd.getDefaultUsage().size() > 0 : attachment == AttachmentMode.MAIN || attachment == AttachmentMode.UNSET);
        } else if (method.isAnnotationPresent(Usage.class)) {
            SubCommand ann = method.getParent().getAnnotation(SubCommand.class);
            if (ann != null) {
                requiresParameterInheritance = ann.attachment().requiresParameterInheritance();
            } else if (parentCmd != null) {
                requiresParameterInheritance = parentCmd.getMainUsage().getParameters().isEmpty();
            }
        }
        return requiresParameterInheritance;
    }

    private boolean isSenderParameter(ParameterElement parameter) {
        Type type = ((Parameter)parameter.getElement()).getParameterizedType();
        return this.imperat.canBeSender(type) || this.config.hasSourceResolver(type);
    }

    private String getMethodParamsCollected(LinkedList<ParameterElement> methodParameters) {
        StringBuilder builder = new StringBuilder();
        for (ParameterElement pe : methodParameters) {
            builder.append(pe.getName()).append(" ");
        }
        return builder.toString();
    }

    @NotNull
    private static <S extends Source> StringBuilder getMainUsageParametersCollected(StrictParameterList<S> mainUsageParameters) {
        StringBuilder builder = new StringBuilder();
        for (CommandParameter commandParameter : mainUsageParameters) {
            builder.append(commandParameter.format()).append(" ");
        }
        return builder;
    }

    @NotNull
    private static <S extends Source> LinkedList<studio.mevera.imperat.command.Command<S>> getParenteralSequence(@Nullable studio.mevera.imperat.command.Command<S> parentCmd) {
        LinkedList<studio.mevera.imperat.command.Command<S>> parenteralSequence = new LinkedList<studio.mevera.imperat.command.Command<S>>();
        for (studio.mevera.imperat.command.Command<S> currentParent = parentCmd; currentParent != null; currentParent = currentParent.parent()) {
            parenteralSequence.addFirst(currentParent);
        }
        return parenteralSequence;
    }

    @Nullable
    private <T> CommandParameter<S> loadParameter(@NotNull ParameterElement parameter) {
        InputParameter param;
        boolean allowsGreedy;
        if (parameter.isContextResolved()) {
            return null;
        }
        Flag flag = parameter.getAnnotation(Flag.class);
        Switch switchAnnotation = parameter.getAnnotation(Switch.class);
        if (flag != null && switchAnnotation != null) {
            throw new IllegalStateException("both @Flag and @Switch at the same time !");
        }
        TypeWrap<?> parameterTypeWrap = TypeWrap.of(((Parameter)parameter.getElement()).getParameterizedType());
        ParameterType<S, ?> type = this.config.getParameterType(parameterTypeWrap.getType());
        if (type == null) {
            throw new IllegalArgumentException("Unknown type detected '" + parameterTypeWrap.getType().getTypeName() + "'");
        }
        String name = parameter.getName();
        boolean optional = parameter.isOptional();
        Suggest suggestAnnotation = parameter.getAnnotation(Suggest.class);
        SuggestionProvider suggestionProvider = parameter.getAnnotation(SuggestionProvider.class);
        SuggestionResolver suggestionResolver = null;
        if (suggestAnnotation != null) {
            suggestionResolver = SuggestionResolver.staticSuggestions(this.config.replacePlaceholders(suggestAnnotation.value()));
        } else if (suggestionProvider != null) {
            String suggestionResolverName = this.config.replacePlaceholders(suggestionProvider.value().toLowerCase());
            SuggestionResolver namedResolver = this.config.getNamedSuggestionResolver(suggestionResolverName);
            if (namedResolver != null) {
                suggestionResolver = namedResolver;
            } else {
                throw new IllegalStateException("Unregistered named suggestion resolver : " + suggestionResolverName);
            }
        }
        boolean greedy = parameter.getAnnotation(Greedy.class) != null;
        boolean bl = allowsGreedy = parameter.getType() == String.class || TypeUtility.isAcceptableGreedyWrapper(parameter.getType()) && TypeUtility.hasGenericType(parameter.getType(), String.class);
        if (greedy && !allowsGreedy) {
            throw new IllegalArgumentException("Argument '" + parameter.getName() + "' is greedy while having a non-greedy valueType '" + parameter.getType().getTypeName() + "'");
        }
        studio.mevera.imperat.command.Description desc = studio.mevera.imperat.command.Description.EMPTY;
        if (parameter.isAnnotationPresent(Description.class)) {
            Description descAnn = parameter.getAnnotation(Description.class);
            assert (descAnn != null);
            desc = studio.mevera.imperat.command.Description.of(this.config.replacePlaceholders(descAnn.value()));
        }
        String permission = null;
        if (parameter.isAnnotationPresent(Permission.class)) {
            Permission permAnn = parameter.getAnnotation(Permission.class);
            assert (permAnn != null);
            permission = this.config.replacePlaceholders(permAnn.value());
        }
        OptionalValueSupplier optionalValueSupplier = OptionalValueSupplier.empty();
        if (optional) {
            Default defaultAnnotation = parameter.getAnnotation(Default.class);
            DefaultProvider provider = parameter.getAnnotation(DefaultProvider.class);
            try {
                optionalValueSupplier = AnnotationHelper.deduceOptionalValueSupplier(parameter, defaultAnnotation, provider, optionalValueSupplier);
            }
            catch (ImperatException e) {
                ImperatDebugger.error(AnnotationHelper.class, "deduceOptionalValueSupplier", e);
            }
        }
        if (flag != null) {
            String[] flagAliases = flag.value();
            if (suggestAnnotation != null) {
                suggestionResolver = SuggestionResolver.staticSuggestions(this.config.replacePlaceholders(suggestAnnotation.value()));
            }
            return AnnotationParameterDecorator.decorate(CommandParameter.flag(name, type).setFree(flag.free()).suggestForInputValue(suggestionResolver).aliases(this.getAllExceptFirst(flagAliases)).flagDefaultInputValue(optionalValueSupplier).description(desc).permission(permission).build(), parameter);
        }
        if (switchAnnotation != null) {
            String[] switchAliases = switchAnnotation.value();
            return AnnotationParameterDecorator.decorate(CommandParameter.flagSwitch(name).setFree(switchAnnotation.free()).aliases(this.getAllExceptFirst(switchAliases)).description(desc).permission(permission).build(), parameter);
        }
        if (parameter.isAnnotationPresent(Values.class)) {
            Values valuesAnnotation = parameter.getAnnotation(Values.class);
            assert (valuesAnnotation != null);
            Set values = Arrays.stream(valuesAnnotation.value()).distinct().map(this.config::replacePlaceholders).flatMap(replaced -> {
                if (replaced.contains("|")) {
                    return Arrays.stream(replaced.split(VALUES_SEPARATION_CHAR));
                }
                return Stream.of(replaced);
            }).collect(Collectors.toCollection(LinkedHashSet::new));
            type = ConstrainedParameterTypeDecorator.of(type, values, valuesAnnotation.caseSensitive());
        }
        CommandParameter<S> delegate = CommandParameter.of(name, type, permission, desc, optional, greedy, optionalValueSupplier, suggestionResolver);
        if (parameter.isAnnotationPresent(Format.class)) {
            Format formatAnnotation = parameter.getAnnotation(Format.class);
            assert (formatAnnotation != null);
            delegate.setFormat(this.config.replacePlaceholders(formatAnnotation.value()));
        }
        if (TypeUtility.isNumericType(TypeWrap.of((param = AnnotationParameterDecorator.decorate(delegate, parameter)).valueType())) && parameter.isAnnotationPresent(Range.class)) {
            Range range = parameter.getAnnotation(Range.class);
            assert (range != null);
            param = NumericParameterDecorator.decorate(param, NumericRange.of(range.min(), range.max()));
        }
        return param;
    }

    private List<String> getAllExceptFirst(String[] array) {
        ArrayList<String> flagAliases = new ArrayList<String>(array.length - 1);
        flagAliases.addAll(List.of(array).subList(1, array.length));
        return flagAliases;
    }

    private record MethodUsageData<S extends Source>(List<CommandParameter<S>> personalParameters, List<CommandParameter<S>> inheritedTotalParameters, Set<FlagData<S>> freeFlags) {
    }
}

