/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.ParameterElement;
import studio.mevera.imperat.annotations.base.element.ParseElement;
import studio.mevera.imperat.command.tree.help.CommandHelp;
import studio.mevera.imperat.context.Source;

public final class MethodElement
extends ParseElement<Method> {
    private final List<ParameterElement> parameters = new ArrayList<ParameterElement>();
    private int inputCount = 0;
    private int optionalCount = 0;
    private boolean help = false;

    public <S extends Source> MethodElement(@NotNull AnnotationParser<S> parser, @Nullable ClassElement owningElement, @NotNull Method element) {
        super(parser, owningElement, element);
        Parameter[] params = element.getParameters();
        for (int i = 0; i < params.length; ++i) {
            Parameter parameter = params[i];
            ParameterElement parameterElement = new ParameterElement(parser, owningElement, this, parameter);
            this.parameters.add(parameterElement);
            if (i <= 0) continue;
            if (!parameterElement.isContextResolved()) {
                ++this.inputCount;
                if (!parameterElement.isOptional()) continue;
                ++this.optionalCount;
                continue;
            }
            if (!((Parameter)parameterElement.getElement()).getType().equals(CommandHelp.class)) continue;
            this.help = true;
        }
    }

    @Nullable
    public ParameterElement getParameterAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.parameters.get(index);
    }

    public int size() {
        return this.parameters.size();
    }

    public Type getReturnType() {
        return ((Method)this.getElement()).getReturnType();
    }

    public int getModifiers() {
        return ((Method)this.getElement()).getModifiers();
    }

    @Override
    public String getName() {
        return ((Method)this.getElement()).getName();
    }

    public List<ParameterElement> getParameters() {
        return this.parameters;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean isAllOptionalInput() {
        return this.inputCount == this.optionalCount;
    }

    @Override
    @NotNull
    public ParseElement<?> getParent() {
        assert (super.getParent() != null);
        return super.getParent();
    }

    public boolean isHelp() {
        return this.help;
    }
}

