/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import studio.mevera.imperat.annotations.ContextResolved;
import studio.mevera.imperat.annotations.Default;
import studio.mevera.imperat.annotations.DefaultProvider;
import studio.mevera.imperat.annotations.Flag;
import studio.mevera.imperat.annotations.Optional;
import studio.mevera.imperat.annotations.Switch;
import studio.mevera.imperat.annotations.base.AnnotationHelper;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.ParseElement;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.TypeWrap;

public final class ParameterElement
extends ParseElement<Parameter> {
    private final String name;
    private final Type type;
    private final ClassElement owningClass;
    private final boolean contextResolved;

    <S extends Source> ParameterElement(AnnotationParser<S> parser, ClassElement owningClass, MethodElement method, Parameter element) {
        super(parser, method, element);
        this.owningClass = owningClass;
        this.name = AnnotationHelper.getParamName(parser.getImperat().config(), this);
        this.type = element.getParameterizedType();
        this.contextResolved = this.calculateIsContextResolved();
    }

    @Override
    public String toString() {
        return ((Parameter)this.getElement()).getType().getSimpleName() + " " + this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public ClassElement getOwningClass() {
        return this.owningClass;
    }

    public boolean isOptional() {
        return this.isAnnotationPresent(Optional.class) || this.isAnnotationPresent(Default.class) || this.isAnnotationPresent(DefaultProvider.class) || this.isAnnotationPresent(Flag.class) || this.isAnnotationPresent(Switch.class);
    }

    public boolean isContextResolved() {
        return this.contextResolved;
    }

    private boolean calculateIsContextResolved() {
        if (this.isAnnotationPresent(ContextResolved.class)) {
            return true;
        }
        if (TypeWrap.of(this.type).getRawType().isAnnotationPresent(ContextResolved.class)) {
            return true;
        }
        for (Annotation annotation : this.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(ContextResolved.class)) continue;
            return true;
        }
        return false;
    }
}

