/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.AnnotationReplacer;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.AnnotationMap;
import studio.mevera.imperat.util.ImperatDebugger;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ParseElement<E extends AnnotatedElement>
implements AnnotatedElement,
Iterable<Annotation> {
    protected final AnnotationParser<?> parser;
    @NotNull
    protected final AnnotationMap annotations = new AnnotationMap();
    @Nullable
    protected final ParseElement<?> parent;
    @NotNull
    protected final E element;

    public <S extends Source> ParseElement(@NotNull AnnotationParser<S> parser, @Nullable ParseElement<?> parent, @NotNull E element) {
        this.parser = parser;
        this.parent = parent;
        this.element = element;
        this.load(parser);
    }

    private <A extends Annotation, S extends Source> void load(@NotNull AnnotationParser<S> registry) {
        for (Annotation annotation : this.element.getDeclaredAnnotations()) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            this.annotations.put(clazz, annotation);
            if (registry.isKnownAnnotation(clazz) || !registry.hasAnnotationReplacerFor(clazz)) continue;
            ImperatDebugger.debug("Found replacer for '@%s' on element '%s'", clazz.getSimpleName(), this.getName());
            this.annotations.put(clazz, annotation);
            AnnotationReplacer<? extends Annotation> replacer = registry.getAnnotationReplacer(clazz);
            assert (replacer != null);
            Collection<Annotation> replacementAnnotations = replacer.replace(this, annotation);
            for (Annotation replacement : replacementAnnotations) {
                this.annotations.put(replacement.annotationType(), replacement);
            }
        }
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(@NotNull Class<T> annotationClass) {
        return (T)((Annotation)this.annotations.get(annotationClass));
    }

    @Override
    public Annotation @NotNull [] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[0]);
    }

    @Override
    public Annotation @NotNull [] getDeclaredAnnotations() {
        return this.annotations.values().toArray(new Annotation[0]);
    }

    @Override
    @NotNull
    public Iterator<Annotation> iterator() {
        return this.annotations.values().iterator();
    }

    public String toString() {
        E e = this.element;
        if (e instanceof Method) {
            Method method = (Method)e;
            return method.getName();
        }
        e = this.element;
        if (e instanceof Class) {
            Class clazz = (Class)e;
            return clazz.getSimpleName();
        }
        return this.element.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParseElement)) {
            return false;
        }
        ParseElement that = (ParseElement)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.element, that.element);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.element);
    }

    public abstract String getName();

    @Nullable
    public ParseElement<?> getParent() {
        return this.parent;
    }

    @NotNull
    public E getElement() {
        return this.element;
    }
}

