/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.annotations.ExceptionHandler;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.CommandClassVisitor;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.MethodThrowableResolver;
import studio.mevera.imperat.annotations.base.element.ParseElement;
import studio.mevera.imperat.annotations.base.element.selector.ElementSelector;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.asm.DefaultMethodCallerFactory;
import studio.mevera.imperat.util.asm.MethodCaller;

final class ThrowableParsingVisitor<S extends Source>
extends CommandClassVisitor<S, Set<MethodThrowableResolver<?, S>>> {
    ThrowableParsingVisitor(Imperat<S> imperat, AnnotationParser<S> parser, ElementSelector<MethodElement> methodSelector) {
        super(imperat, parser, methodSelector);
    }

    @Override
    public Set<MethodThrowableResolver<?, S>> visitCommandClass(@NotNull ClassElement clazz) {
        HashSet throwableResolvers = new HashSet();
        for (ParseElement<?> childElement : clazz.getChildren()) {
            MethodThrowableResolver resolverLoaded;
            MethodElement methodElement;
            if (!(childElement instanceof MethodElement) || !this.methodSelector.canBeSelected(this.imperat, this.parser, methodElement = (MethodElement)childElement, false) || (resolverLoaded = this.loadResolver(clazz, methodElement)) == null) continue;
            throwableResolvers.add(resolverLoaded);
        }
        return throwableResolvers;
    }

    @Nullable
    private <E extends Throwable> MethodThrowableResolver<E, S> loadResolver(ClassElement owner, MethodElement methodElement) {
        try {
            ExceptionHandler ann = methodElement.getAnnotation(ExceptionHandler.class);
            if (ann == null) {
                return null;
            }
            Class<? extends Throwable> exceptionType = ann.value();
            MethodCaller.BoundMethodCaller caller = DefaultMethodCallerFactory.INSTANCE.createFor((Method)methodElement.getElement()).bindTo(owner.getObjectInstance());
            return new MethodThrowableResolver(caller, exceptionType);
        }
        catch (Throwable e) {
            ImperatDebugger.warning("Failed to register throwable-method '" + methodElement.getName() + "' in class '" + String.valueOf(owner.getChildren()) + "'", new Object[0]);
            e.printStackTrace();
            return null;
        }
    }
}

