/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element.selector;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.annotations.base.AnnotationParser;
import studio.mevera.imperat.annotations.base.element.ParseElement;
import studio.mevera.imperat.annotations.base.element.selector.Rule;
import studio.mevera.imperat.annotations.base.element.selector.SimpleElementSelector;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ElementSelector<E extends ParseElement<?>> {
    @NotNull
    public List<Rule<E>> getRules();

    default public void verifyWithFail(Rule<E> rule, Imperat<?> imperat, AnnotationParser<?> registry, E element) {
        if (!rule.test(imperat, registry, element)) {
            rule.onFailure(registry, element);
        }
    }

    default public ElementSelector<E> addRule(Rule<E> rule) {
        this.getRules().add(rule);
        return this;
    }

    default public void removeRule(Rule<E> rule) {
        this.getRules().remove(rule);
    }

    default public boolean canBeSelected(Imperat<?> imperat, AnnotationParser<?> parse, E element, boolean fail) {
        for (Rule<E> rule : this.getRules()) {
            if (rule.test(imperat, parse, element)) continue;
            if (fail) {
                rule.onFailure(parse, element);
            }
            return false;
        }
        return true;
    }

    public static <E extends ParseElement<?>> ElementSelector<E> create() {
        return new SimpleElementSelector();
    }
}

