/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.base.element.selector;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import studio.mevera.imperat.annotations.ExceptionHandler;
import studio.mevera.imperat.annotations.base.element.ClassElement;
import studio.mevera.imperat.annotations.base.element.MethodElement;
import studio.mevera.imperat.annotations.base.element.ParameterElement;
import studio.mevera.imperat.annotations.base.element.selector.Rule;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeWrap;

public interface MethodRules {
    public static final Rule<MethodElement> IS_PUBLIC = Rule.buildForMethod().condition((imperat, registry, method) -> Modifier.isPublic(method.getModifiers())).failure((registry, method) -> {
        throw MethodRules.methodError(method, "is not public");
    }).build();
    public static final Rule<MethodElement> HAS_KNOWN_SENDER = Rule.buildForMethod().condition((imperat, registry, method) -> {
        ParameterElement parameterElement = method.getParameterAt(0);
        if (parameterElement == null) {
            return false;
        }
        return imperat.canBeSender(parameterElement.getType()) || imperat.config().hasSourceResolver(parameterElement.getType());
    }).failure((registry, method) -> {
        ParameterElement parameterElement = method.getParameterAt(0);
        String msg = parameterElement == null ? "Method '" + method.getName() + "' has no parameters" : "First parameter of valueType '" + parameterElement.getType().getTypeName() + "' is not a sub-valueType of `" + Source.class.getName() + "'";
        throw MethodRules.methodError(method, msg);
    }).build();
    public static final Rule<MethodElement> HAS_A_MAIN_ANNOTATION = Rule.buildForMethod().condition((imperat, registry, element) -> {
        long count = Arrays.stream(element.getDeclaredAnnotations()).filter(annotation -> registry.isEntryPointAnnotation(annotation.annotationType())).count();
        return count > 0L;
    }).failure((registry, element) -> {
        throw MethodRules.methodError(element, "doesn't have any main annotations!");
    }).build();
    public static final Rule<MethodElement> HAS_EXCEPTION_HANDLER_ANNOTATION = Rule.builder().condition((imp, parser, methodElement) -> methodElement.getDeclaredAnnotation(ExceptionHandler.class) != null).build();
    public static final Rule<MethodElement> HAS_EXCEPTION_HANDLER_PARAMS_IN_ORDER = Rule.builder().condition((imp, parser, methodElement) -> {
        List<ParameterElement> params = methodElement.getParameters();
        if (params.size() != 2) {
            return false;
        }
        ParameterElement first = params.get(0);
        ParameterElement second = params.get(1);
        return TypeWrap.of(((Parameter)first.getElement()).getType()).isSubtypeOf((Type)((Object)Throwable.class)) && TypeUtility.matches(((Parameter)second.getElement()).getType(), Context.class);
    }).build();

    private static IllegalStateException methodError(MethodElement element, String msg) {
        ClassElement parent = (ClassElement)element.getParent();
        return new IllegalStateException(String.format("Method '%s' In class '%s' " + msg, ((Method)element.getElement()).getName(), ((Class)parent.getElement()).getName()));
    }
}

