/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.annotations.parameters;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.InputParameter;
import studio.mevera.imperat.command.parameters.NumericParameter;
import studio.mevera.imperat.command.parameters.NumericRange;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.SuggestionResolver;

public final class NumericParameterDecorator<S extends Source>
extends InputParameter<S>
implements NumericParameter<S> {
    private final CommandParameter<S> parameter;
    private final NumericRange range;

    NumericParameterDecorator(CommandParameter<S> parameter, NumericRange range) {
        super(parameter.name(), parameter.type(), parameter.getSinglePermission(), parameter.description(), parameter.isOptional(), parameter.isFlag(), parameter.isFlag(), parameter.getDefaultValueSupplier(), NumericParameterDecorator.loadSuggestionResolver(parameter, range));
        this.parameter = parameter;
        this.range = range;
    }

    public static <S extends Source> NumericParameterDecorator<S> decorate(@NotNull CommandParameter<S> parameter, @NotNull NumericRange range) {
        return new NumericParameterDecorator<S>(parameter, range);
    }

    @Override
    public String format() {
        return this.parameter.format();
    }

    @Override
    @Nullable
    public NumericRange getRange() {
        return this.range;
    }

    private static <S extends Source> SuggestionResolver<S> loadSuggestionResolver(CommandParameter<S> parameter, NumericRange range) {
        SuggestionResolver<S> def = parameter.getSuggestionResolver();
        if (parameter.getSuggestionResolver() != null || range.getMin() == Double.MIN_VALUE && range.getMax() == Double.MAX_VALUE) {
            return def;
        }
        String suggestion = range.getMin() != Double.MIN_VALUE && range.getMax() == Double.MAX_VALUE ? "" + range.getMin() : (range.getMin() == Double.MIN_VALUE ? "" + range.getMax() : range.getMin() + "-" + range.getMax());
        return SuggestionResolver.staticSuggestions(suggestion);
    }

    @Override
    public CommandParameter<S> copyWithDifferentPosition(int newPosition) {
        CommandParameter<S> copiedParameter = this.parameter.copyWithDifferentPosition(newPosition);
        return new NumericParameterDecorator<S>(copiedParameter, this.range);
    }
}

